/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;

public class UrlHttpValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(UrlHttpValidator.class.getName());
    private static final String LogPrefix = "UrlHttpValidator - ";

    public boolean validate(ProcessingClient client) {
        String url = "";
        boolean retValue = false;
        try {
            url = client.getFieldContents(0).trim();
        }
        catch (Exception e) {
            return false;
        }
        try {
            if (!url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
                url = "http://" + url;
            }
            URL obj = URI.create(url).toURL();
            HttpURLConnection connection = (HttpURLConnection)obj.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            logger.log(Level.FINE, "UrlHttpValidator - Response Code: " + responseCode);
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                retValue = true;
                logger.log(Level.FINE, "UrlHttpValidator - Response: " + response.toString());
            } else {
                retValue = false;
                logger.log(Level.FINE, "UrlHttpValidator - Failed to connect to " + url + ". Response Code: " + responseCode);
            }
        }
        catch (UnknownHostException unknownHostEx) {
            logger.log(Level.SEVERE, "UrlHttpValidator - Error occurred (UnknownHostException): " + unknownHostEx.getMessage());
        }
        catch (ConnectException connectEx) {
            logger.log(Level.SEVERE, "UrlHttpValidator - Error occurred (ConnectException): " + connectEx.getMessage());
        }
        catch (SSLHandshakeException notValidCertifEx) {
            logger.log(Level.WARNING, "UrlHttpValidator - SSLHandshakeException (" + url + "): " + notValidCertifEx.getMessage());
            retValue = true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "UrlHttpValidator - Error: " + ex.getMessage() + " Stack: " + Arrays.toString(ex.getStackTrace()));
        }
        return retValue;
    }
}

