/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnixGroupsValidator
implements DataValidator,
Validator {
    private static final Logger logger = Logger.getLogger(UnixGroupsValidator.class.getName());
    private static final String LogLabel = "UnixGroupsValidator - ";
    private ArrayList<String> groups = null;

    public boolean validate(ProcessingClient client) {
        boolean result = false;
        String groupName = client.getText();
        result = this.isValidGroup(groupName);
        logger.log(Level.FINE, "UnixGroupsValidator - validate groupName: " + groupName + " isValid:" + result);
        return result;
    }

    public boolean isValidGroup(String groupName) {
        if (this.groups == null) {
            this.initGroups();
        }
        for (String group : this.groups) {
            logger.log(Level.FINE, "UnixGroupsValidator - Compare entry group '" + groupName + "'=='" + group + "'");
            if (!groupName.equals(group)) continue;
            return true;
        }
        return false;
    }

    private void initGroups() {
        this.groups = new ArrayList();
        String retValue = "";
        String filepath = "/etc/group";
        BufferedReader reader = null;
        String line = "";
        try {
            reader = new BufferedReader(new FileReader(filepath));
            while ((line = reader.readLine()) != null) {
                retValue = line.substring(0, line.indexOf(":"));
                this.groups.add(retValue);
            }
        }
        catch (Exception ex) {
            retValue = "";
        }
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "groupNameNotFound";
    }

    @Override
    public String getWarningMessageId() {
        return "groupNameNotFound";
    }

    @Override
    public DataValidator.Status validateData(InstallData arg0) {
        return DataValidator.Status.OK;
    }
}

