/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.izforge.izpack.Pack;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.sage.izpack.InstallationInformationHelper;
import com.sage.izpack.SageInstallationInfo;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SageInstallationInformationHelper {
    private static final Logger logger = Logger.getLogger(InstallationInformationHelper.class.getName());
    private static final String logPrefix = "SageInstallationInformationHelper - ";
    public static final String SageInstallInformation = "install-information.json";
    private static final String ReadSageInstallationInformation = "read-sage-installation-information";
    private static final String WriteSageInstallationInformation = "write-sage-installation-information";

    public static boolean readSageInformationEnable(InstallData installData) {
        String readSageInfo = installData.getVariable(ReadSageInstallationInformation);
        return !StringUtil.isNullOrBlank(readSageInfo) && readSageInfo.equalsIgnoreCase("true");
    }

    public static boolean writeSageInformationEnable(InstallData installData) {
        String readSageInfo = installData.getVariable(WriteSageInstallationInformation);
        return !StringUtil.isNullOrBlank(readSageInfo) && readSageInfo.equalsIgnoreCase("true");
    }

    private static void LogDebug(Level level, String message) {
        logger.log(level, logPrefix + message);
        System.out.println(logPrefix + message);
    }

    public static SageInstallationInfo readFromSageInstallationInfo(String installPath) {
        File sageInstallationInformation = new File(installPath + File.separator + SageInstallInformation);
        if (!sageInstallationInformation.exists()) {
            SageInstallationInformationHelper.LogDebug(Level.SEVERE, "Error in readFromSageInstallationInfoMapper(): File " + sageInstallationInformation.getAbsolutePath() + " doesn't exist.");
            return null;
        }
        try {
            FileReader reader = new FileReader(sageInstallationInformation.getAbsoluteFile());
            Gson gson = new GsonBuilder().create();
            SageInstallationInfo info = gson.fromJson((Reader)reader, SageInstallationInfo.class);
            return info;
        }
        catch (Exception e) {
            SageInstallationInformationHelper.LogDebug(Level.SEVERE, "Error while reading JSON file " + sageInstallationInformation.getAbsolutePath() + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void createSageInstallationInfo(InstallData installData) {
        if (installData == null) {
            logger.log(Level.SEVERE, "SageInstallationInformationHelper -  Error: createSageInstallationInfo(installData = NULL)");
            return;
        }
        File sageInstallationInformation = new File(installData.getInstallPath() + File.separator + SageInstallInformation);
        try {
            LinkedHashMap<String, Cloneable> root = new LinkedHashMap<String, Cloneable>();
            LinkedHashMap<String, String> information = new LinkedHashMap<String, String>();
            String appName = installData.getInfo().getAppName();
            if (StringUtil.isNullOrBlank(appName)) {
                appName = installData.getVariable("APP_NAME");
            }
            if (StringUtil.isNullOrBlank(appName)) {
                appName = installData.getVariable("UNINSTALL_NAME");
            }
            information.put("appName", appName);
            information.put("installPath", installData.getInstallPath());
            information.put("appVersion", installData.getInfo().getAppVersion());
            information.put("uninstallName", installData.getVariable("UNINSTALL_NAME"));
            root.put("information", information);
            ArrayList variablesList = new ArrayList();
            Variables variables = installData.getVariables();
            if (variables != null) {
                Properties variablesProp = variables.getProperties();
                for (Object object : variablesProp.keySet()) {
                    LinkedHashMap<String, String> varEntry = new LinkedHashMap<String, String>();
                    String key = (String)object;
                    String value = (String)variablesProp.get(object);
                    varEntry.put("name", key);
                    varEntry.put("value", value);
                    variablesList.add(varEntry);
                    logger.log(Level.FINE, "SageInstallationInformationHelper - Put Json variable: " + key + "=" + value);
                }
            }
            root.put("variables", variablesList);
            ArrayList packsList = new ArrayList();
            List<com.izforge.izpack.api.data.Pack> packsinstalled = installData.getAvailablePacks();
            for (com.izforge.izpack.api.data.Pack obj : packsinstalled) {
                Serializable pack;
                LinkedHashMap<String, Object> packEntry = new LinkedHashMap<String, Object>();
                if (obj instanceof Pack) {
                    pack = (Pack)((Object)obj);
                    packEntry.put("name", ((Pack)pack).name);
                    packEntry.put("description", ((Pack)pack).description);
                    packEntry.put("required", ((Pack)pack).required);
                    packEntry.put("preselect", ((Pack)pack).preselected);
                } else if (obj instanceof com.izforge.izpack.api.data.Pack) {
                    pack = obj;
                    packEntry.put("name", ((com.izforge.izpack.api.data.Pack)pack).getName());
                    packEntry.put("description", ((com.izforge.izpack.api.data.Pack)pack).getDescription());
                    packEntry.put("required", ((com.izforge.izpack.api.data.Pack)pack).isRequired());
                    packEntry.put("preselect", ((com.izforge.izpack.api.data.Pack)pack).isPreselected());
                }
                packsList.add(packEntry);
            }
            root.put("packs", packsList);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter writer = new FileWriter(sageInstallationInformation);){
                gson.toJson(root, (Appendable)writer);
            }
            logger.log(Level.FINE, "JSON file created successfully: " + sageInstallationInformation.getAbsolutePath());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in JSON file " + sageInstallationInformation.getAbsolutePath() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

