/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.action.ButtonAction;
import com.izforge.izpack.util.Console;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeneratePasswordBtAction
extends ButtonAction {
    private static final String CHAR_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    private static final String CHAR_UPPERCASE = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String DIGIT = "0123456789";
    private static final String OTHER_SPECIAL = "!@#$%^&*()_+-={}:<>?,./~`";
    private static final Logger logger = Logger.getLogger(GeneratePasswordBtAction.class.getName());

    public GeneratePasswordBtAction(InstallData installData) {
        super(installData);
    }

    public boolean execute() {
        logger.log(Level.FINE, "GeneratePasswordHelper execute");
        String password = this.generateStrongPassword(32, false);
        this.installData.setVariable("syracuse.secret", password);
        return true;
    }

    public boolean execute(Console console) {
        if (!this.execute()) {
            console.println("ERROR");
            return false;
        }
        return true;
    }

    public boolean execute(Prompt prompt) {
        if (!this.execute()) {
            prompt.warn("ERROR");
            return false;
        }
        return true;
    }

    public String generateStrongPassword(int length, boolean useSpecialCharacters) {
        StringBuilder result = new StringBuilder(length);
        String strLowerCase = GeneratePasswordBtAction.generateRandomString(CHAR_LOWERCASE, 2);
        result.append(strLowerCase);
        String strUppercaseCase = GeneratePasswordBtAction.generateRandomString(CHAR_UPPERCASE, 2);
        result.append(strUppercaseCase);
        String strDigit = GeneratePasswordBtAction.generateRandomString(DIGIT, 2);
        result.append(strDigit);
        if (useSpecialCharacters) {
            String strSpecialChar = GeneratePasswordBtAction.generateRandomString(OTHER_SPECIAL, 2);
            result.append(strSpecialChar);
        }
        String strOther = GeneratePasswordBtAction.generateRandomString(GeneratePasswordBtAction.getAllowedChars(length - result.length() - 2, useSpecialCharacters), length - result.length());
        result.append(strOther);
        String shuffledPassword = GeneratePasswordBtAction.shuffleString(result.toString());
        return strLowerCase + shuffledPassword;
    }

    private static String generateRandomString(String input, int size) {
        if (input == null || input.length() <= 0) {
            throw new IllegalArgumentException("Invalid input.");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size.");
        }
        StringBuilder result = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            int index = new SecureRandom().nextInt(input.length());
            result.append(input.charAt(index));
        }
        return result.toString();
    }

    private static String shuffleString(String input) {
        ArrayList<Character> chars = new ArrayList<Character>();
        for (char c : input.toCharArray()) {
            chars.add(Character.valueOf(c));
        }
        Collections.shuffle(chars);
        StringBuilder result = new StringBuilder();
        Iterator iterator = chars.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            result.append(c);
        }
        return result.toString();
    }

    private static String getAllowedChars(int length, boolean useSpecialCharacters) {
        StringBuilder allowedChars = new StringBuilder();
        allowedChars.append(CHAR_LOWERCASE).append(CHAR_UPPERCASE).append(DIGIT);
        if (useSpecialCharacters) {
            allowedChars.append(OTHER_SPECIAL);
        }
        return allowedChars.toString();
    }
}

