/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckPwshValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckPwshValidator.class.getName());
    private static final String prefixLabel = "CheckPwshValidator - ";
    private String strMessage = "";
    public static final String strMessageId = "pwshnotinstalled";
    public static final String strMessageValue = "pwshnotinstalled.oldvalue";
    private final String miniPwshVersion72 = "7.2";

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        return this.checkPwsh(installData);
    }

    protected DataValidator.Status checkPwsh(InstallData installData) {
        block9: {
            logger.log(Level.FINE, "CheckPwshValidator - validateData: checking for PowerShell 7.2+ (pwsh)");
            ProcessBuilder pb = new ProcessBuilder("pwsh", "-version");
            pb.redirectErrorStream(true);
            try {
                String line;
                Process process = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuilder output = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
                boolean finished = process.waitFor(5L, TimeUnit.SECONDS);
                if (!finished) {
                    process.destroy();
                    this.strMessage = "Timeout: PowerShell process took too long.";
                    installData.setVariable(strMessageValue, this.strMessage);
                    logger.log(Level.FINE, "CheckPwshValidator - validateData: " + this.strMessage);
                    return DataValidator.Status.OK;
                }
                int exitCode = process.exitValue();
                if (exitCode == 0) {
                    logger.log(Level.FINE, "CheckPwshValidator - validateData: OK  Output=" + output.toString());
                    String versionStr = output.toString().trim();
                    String[] parts = versionStr.split(" ");
                    if (parts.length != 2) break block9;
                    String versionNumber = parts[1].trim();
                    try {
                        boolean isVersionOk;
                        boolean isItAVersion = versionNumber.matches("\\d+\\.\\d+(\\.\\d+)?");
                        if (!isItAVersion) {
                            logger.log(Level.WARNING, "CheckPwshValidator - validateData: Invalid version format pwsh '" + versionNumber + "'");
                            break block9;
                        }
                        boolean bl = isVersionOk = versionNumber.compareTo("7.2") >= 0;
                        if (!isVersionOk) {
                            logger.log(Level.WARNING, "CheckPwshValidator - Min. Required PowerShell version NOT OK - '" + versionNumber + "' < '" + "7.2" + "'. Please update your PowerShell to at least version >= " + "7.2");
                            break block9;
                        }
                        logger.log(Level.FINE, "CheckPwshValidator - validateData: OK (pwsh " + versionNumber + ")");
                    }
                    catch (Exception ex) {
                        logger.log(Level.FINE, "CheckPwshValidator - validateData: Parsing error versionNumber=" + versionNumber);
                    }
                    break block9;
                }
                this.strMessage = "PowerShell 7.2+ (pwsh) is not installed or not in PATH.";
                logger.log(Level.FINE, "CheckPwshValidator - validateData: ExitCode=" + exitCode + "  " + this.strMessage);
                installData.setVariable(strMessageValue, this.strMessage);
                return DataValidator.Status.ERROR;
            }
            catch (IOException | InterruptedException e) {
                this.strMessage = "Error while checking PowerShell version: " + e.getMessage();
                installData.setVariable(strMessageValue, this.strMessage);
                logger.log(Level.FINE, "CheckPwshValidator - validateData -  " + this.strMessage + " - " + e.getMessage());
                return DataValidator.Status.ERROR;
            }
        }
        return DataValidator.Status.OK;
    }
}

