/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sage.izpack.CertificateGeneratorHelper;
import com.sage.izpack.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class CheckMongoDbCertificateP12Validator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckMongoDbCertificateP12Validator.class.getName());
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        try {
            String serverPassphrase = installData.getVariable("mongodb.ssl.serverpassphrase");
            if (StringUtil.isNullOrBlank(serverPassphrase)) {
                serverPassphrase = installData.getVariable("mongodb.ssl.pemkeypassword");
            }
            CheckMongoDbCertificateP12Validator.writeP12File(serverPassphrase, installData);
            return DataValidator.Status.OK;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            installData.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    static void writeP12File(String serverPassphrase, InstallData installData) throws Exception {
        InputStreamReader keyStreamReader;
        InputStream inCertFile;
        String certPathDir = installData.getVariable("mongodb.dir.certs");
        String hostname = installData.getVariable("mongodb.ssl.certificate.hostname");
        String pemKeyFile = certPathDir + File.separator + hostname + ".pem";
        String certFile = certPathDir + File.separator + hostname + ".crt";
        String privKeyFile = certPathDir + File.separator + hostname + ".key";
        if (!new File(privKeyFile).exists()) {
            byte[] certAndKey = Files.readAllBytes(Paths.get(pemKeyFile, new String[0]));
            String delimiter = "-----END CERTIFICATE-----";
            String[] tokens = new String(certAndKey).split(delimiter);
            byte[] certBytes = tokens[0].concat(delimiter).getBytes();
            byte[] keyBytes = tokens[1].getBytes();
            inCertFile = new ByteArrayInputStream(certBytes);
            keyStreamReader = new InputStreamReader(new ByteArrayInputStream(keyBytes));
        } else {
            InputStream inPrivKeyFile = Files.newInputStream(Paths.get(privKeyFile, new String[0]), new OpenOption[0]);
            keyStreamReader = new InputStreamReader(inPrivKeyFile);
            inCertFile = Files.newInputStream(Paths.get(certFile, new String[0]), new OpenOption[0]);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate serverCertificate = (X509Certificate)factory.generateCertificate(inCertFile);
        X500Principal x500Principal = serverCertificate.getSubjectX500Principal();
        String name = x500Principal.getName();
        String cname = CertificateGeneratorHelper.extractCommonName(name);
        installData.setVariable("mongodb.ssl.certificate.cname", cname);
        logger.log(Level.FINE, "Set certificate cname " + cname);
        String thumbPrint = CertificateGeneratorHelper.getThumbprint(serverCertificate);
        installData.setVariable("mongodb.ssl.certificate.thumbprint", thumbPrint);
        logger.log(Level.FINE, "Set certificate thumbPrint " + thumbPrint);
        String p12Filename = certPathDir + File.separator + hostname + ".p12";
        String p12File = CertificateGeneratorHelper.buildP12Certificate(p12Filename, serverPassphrase, serverCertificate, keyStreamReader, cname);
        logger.log(Level.FINE, "P12 file create: " + p12File);
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

