/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.path;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;
import java.io.File;
import java.util.Properties;

public class PathInputConsolePanel
extends AbstractConsolePanel {
    protected String targetPanel;
    private final Prompt prompt;
    private InstallData installData;

    public PathInputConsolePanel(PanelView<ConsolePanel> panel, String targetPanel, InstallData installData, Prompt prompt) {
        super(panel);
        this.targetPanel = targetPanel;
        this.installData = installData;
        this.prompt = prompt;
    }

    protected String getMessage(String subkey) {
        String msg = this.getI18nStringForClass(subkey, this.targetPanel, this.installData);
        if (msg == null) {
            msg = this.targetPanel + "." + subkey;
        }
        return msg;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        this.installData = installData;
        return false;
    }

    protected boolean checkCreateDirectory(File dir, Console console) {
        boolean result = true;
        String show = this.getPanel().getConfigurationOptionValue("ShowCreateDirectoryMessage", this.installData.getRules());
        if (show == null || Boolean.parseBoolean(show)) {
            Messages messages = this.installData.getMessages();
            result = Prompt.Option.OK == this.prompt.confirm(Prompt.Type.WARNING, messages.get("installer.Message", new Object[0]), this.getMessage("createdir") + "\n" + dir, Prompt.Options.OK_CANCEL, Prompt.Option.OK);
        }
        return result;
    }

    protected boolean checkOverwrite(File dir, Console console) {
        boolean result = true;
        String show = this.getPanel().getConfigurationOptionValue("ShowExistingDirectoryWarning", this.installData.getRules());
        if ((show == null || Boolean.parseBoolean(show)) && dir.isDirectory() && dir.list().length > 0) {
            Messages messages = this.installData.getMessages();
            result = this.askUser(messages.get("installer.warning", new Object[0]), this.getMessage("exists_warn"), Prompt.Option.NO);
        }
        return result;
    }

    private boolean askUser(String title, String message, Prompt.Option defaultOption) {
        return Prompt.Option.YES == this.prompt.confirm(Prompt.Type.QUESTION, title, message, Prompt.Options.YES_NO, defaultOption);
    }
}

