/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.optional;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class OptionalSoftwarePanel
extends IzPanel {
    private RulesEngine rules;
    private UninstallDataWriter myUninstallDataWriter;
    private Log myLog;
    private JCheckBox gitInstalled;
    private JRadioButton installGitYes;
    private JRadioButton installGitNo;
    private ButtonGroup installGitSelection;
    private JLabel gitCanBeInstalled;
    private final Insets defaultInset = new Insets(0, 70, 0, 0);
    private final Insets indentedInset = new Insets(0, 150, 0, 0);
    private final Border paddingBorder = BorderFactory.createEmptyBorder(0, 70, 0, 150);

    public OptionalSoftwarePanel(Panel panel, InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources, RulesEngine rulesEngine, UninstallDataWriter uninstallDataWriter, Log log) {
        super(panel, installerFrame, gUIInstallData, new IzPanelLayout(log), resources);
        this.rules = rulesEngine;
        this.myUninstallDataWriter = uninstallDataWriter;
        this.myLog = log;
    }

    @Override
    public void panelActivate() {
        this.configureFields();
        this.getLayoutHelper().completeLayout();
        this.myLog.informUser();
    }

    private void configureFields() {
        Boolean bl = this.rules.isConditionTrue("is.git.installed");
        if (!bl.booleanValue()) {
            this.gitCanBeInstalled = LabelFactory.create(this.parseText(this.getString("git.can.be.installed.message")));
            this.gitCanBeInstalled.setBorder(this.paddingBorder);
            this.add(this.gitCanBeInstalled);
            this.add(IzPanelLayout.createVerticalStrut(5));
            this.installGitYes = new JRadioButton(this.getString("option.yes"));
            this.installGitYes.setMargin(this.indentedInset);
            this.installGitYes.setActionCommand("true");
            this.installGitYes.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        OptionalSoftwarePanel.this.installData.setVariable("install.git.selected", "true");
                    }
                }
            });
            this.installGitNo = new JRadioButton(this.getString("option.no"));
            this.installGitNo.setSelected(true);
            this.installGitNo.setMargin(this.indentedInset);
            this.installGitNo.setActionCommand("false");
            this.installGitNo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        OptionalSoftwarePanel.this.installData.setVariable("install.git.selected", "false");
                    }
                }
            });
            this.installGitSelection = new ButtonGroup();
            this.installGitSelection.add(this.installGitYes);
            this.installGitSelection.add(this.installGitNo);
            this.add((Component)this.installGitYes, "nextLine");
            this.add((Component)this.installGitNo, "nextLine");
        } else {
            this.gitInstalled = new JCheckBox();
            this.gitInstalled.setSelected(bl);
            this.gitInstalled.setMargin(this.defaultInset);
            this.gitInstalled.setForeground(new Color(0, 0, 0));
            this.gitInstalled.setEnabled(false);
            this.gitInstalled.setText(this.parseText(this.getString("git.installed.message")));
            this.add((Component)this.gitInstalled, "nextLine");
        }
    }
}

