/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.nexusconnection;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.MultiLineLabel;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NexusConnectionPanel
extends IzPanel {
    private Log myLog;
    private JLabel userNameLabel;
    private JTextField userName;
    private JLabel userPasswordLabel;
    private JPasswordField userPassword;
    private final Insets defaultInset = new Insets(5, 0, 5, 0);
    private final Border paddingBorder = BorderFactory.createEmptyBorder(5, 70, 5, 5);
    private RulesEngine rules;
    private UninstallDataWriter myUninstallDataWriter;

    public NexusConnectionPanel(Panel panel, InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources, RulesEngine rulesEngine, UninstallDataWriter uninstallDataWriter, Log log) {
        super(panel, installerFrame, gUIInstallData, new IzPanelLayout(log), resources);
        this.rules = rulesEngine;
        this.myUninstallDataWriter = uninstallDataWriter;
        this.myLog = log;
    }

    @Override
    public void panelActivate() {
        this.configureFields();
        this.getLayoutHelper().completeLayout();
        this.myLog.informUser();
    }

    private void configureFields() {
        Boolean bl = this.rules.isConditionTrue("is.upgrade");
        String string = "";
        if (!bl.booleanValue()) {
            this.parent.lockPrevButton();
            this.installData.setVariable("update.password", "true");
        } else {
            MultiLineLabel multiLineLabel;
            string = this.getNpmLoggedInUser();
            this.installData.setVariable("update.password", "false");
            switch (string) {
                case "unknown": {
                    multiLineLabel = new MultiLineLabel(this.processMultilineString(this.getString("nexus.unknown.error.message")), 0);
                    multiLineLabel.setForeground(new Color(255, 153, 0));
                    break;
                }
                case "Authentication Error": {
                    multiLineLabel = new MultiLineLabel(this.processMultilineString(this.getString("nexus.authentication.error.message")), 0);
                    multiLineLabel.setForeground(Color.RED);
                    this.installData.setVariable("update.password", "true");
                    break;
                }
                case "No User Connection": {
                    multiLineLabel = new MultiLineLabel(this.processMultilineString(this.getString("nexus.missing.user.error.message")), 0);
                    multiLineLabel.setForeground(Color.RED);
                    this.installData.setVariable("update.password", "true");
                    break;
                }
                default: {
                    multiLineLabel = new MultiLineLabel(this.processMultilineString(this.getString("nexus.user.correct.message")).replace("${nexusUser}", string), 0);
                }
            }
            multiLineLabel.setBorder(this.paddingBorder);
            this.add((Component)multiLineLabel, "nextLine");
            this.add(IzPanelLayout.createVerticalStrut(10), "nextLine");
        }
        this.userNameLabel = LabelFactory.create(this.getString("nexusconnection.username"), (Icon)this.parent.getIcons().get("empty"), 10);
        this.userNameLabel.setBorder(this.paddingBorder);
        this.userName = new JTextField(30);
        this.userName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setVariable();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setVariable();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.setVariable();
            }

            public void setVariable() {
                if (NexusConnectionPanel.this.userName.getText().length() > 0) {
                    NexusConnectionPanel.this.installData.setVariable("atp.user.name", NexusConnectionPanel.this.userName.getText());
                }
            }
        });
        this.userName.setMargin(this.defaultInset);
        if (this.installData.getVariable("update.password") == "true") {
            this.userName.setEnabled(true);
        } else {
            this.userName.setEnabled(false);
            this.userName.setText(string);
        }
        this.add((Component)this.userNameLabel, "nextLine");
        this.add((Component)this.userName, -1);
        this.userPasswordLabel = LabelFactory.create(this.getString("nexusconnection.userpassword"), (Icon)this.parent.getIcons().get("empty"), 10);
        this.userPasswordLabel.setBorder(this.paddingBorder);
        this.userPassword = new JPasswordField(30);
        this.userPassword.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setVariable();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setVariable();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.setVariable();
            }

            public void setVariable() {
                if (NexusConnectionPanel.this.userPassword.getPassword().length > 0) {
                    NexusConnectionPanel.this.installData.setVariable("atp.user.password", new String(NexusConnectionPanel.this.userPassword.getPassword()));
                }
            }
        });
        this.userPassword.setMargin(this.defaultInset);
        if (this.installData.getVariable("update.password") == "true") {
            this.userPassword.setEnabled(true);
        } else {
            this.userPassword.setEnabled(false);
            this.userPassword.setText("**********");
        }
        this.add((Component)this.userPasswordLabel, "nextLine");
        this.add((Component)this.userPassword, -1);
    }

    @Override
    public boolean isValidated() {
        if (this.installData.getVariable("update.password") == "true") {
            if (this.userName.getText().length() == 0) {
                this.emitError(this.getString("empty.username.error.title"), this.getString("empty.username.error.message"));
                this.parent.lockPrevButton();
                return false;
            }
            if (this.userPassword.getPassword().length == 0) {
                this.emitError(this.getString("empty.userpassword.error.title"), this.getString("empty.userpassword.error.message"));
                this.parent.lockPrevButton();
                return false;
            }
            this.parent.lockPrevButton();
        }
        return true;
    }

    private String getNpmLoggedInUser() {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("powershell.exe npm whoami --registry=https://repository.sagex3.com:8443/repository/atp-npm/");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
                System.out.println(string);
            }
            while ((string = bufferedReader2.readLine()) != null) {
                arrayList2.add(string);
                System.out.println(string);
            }
            int n = process.waitFor();
            if (n != 0) {
                return this.getErrorType(arrayList2);
            }
            return (String)arrayList.get(0);
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    private String getErrorType(List<String> list) {
        for (String string : list) {
            if (!string.contains("Unable to authenticate")) continue;
            return "Authentication Error";
        }
        for (String string : list) {
            if (!string.contains("ENEEDAUTH")) continue;
            return "No User Connection";
        }
        return "unknown";
    }

    private String processMultilineString(String string) {
        string = this.parseText(string).replace("\\n", "\n");
        return string;
    }
}

