/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.prerequisite;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JCheckBox;

public class PrerequisiteSoftwarePanel
extends IzPanel {
    private RulesEngine rules;
    private Log myLog;
    private UninstallDataWriter myUninstallDataWriter;
    private JCheckBox javaInstalled;
    private JCheckBox chromeInstalled;
    private final Insets defaultInset = new Insets(10, 70, 0, 0);

    public PrerequisiteSoftwarePanel(Panel panel, InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources, RulesEngine rulesEngine, UninstallDataWriter uninstallDataWriter, Log log) {
        super(panel, installerFrame, gUIInstallData, new IzPanelLayout(log), resources);
        this.rules = rulesEngine;
        this.myUninstallDataWriter = uninstallDataWriter;
        this.myLog = log;
    }

    @Override
    public void panelActivate() {
        this.configureFields();
        this.getLayoutHelper().completeLayout();
        this.myLog.informUser();
    }

    private void configureFields() {
        Boolean bl = this.rules.isConditionTrue("is.java.installed");
        Boolean bl2 = this.rules.isConditionTrue("is.chrome.installed");
        this.javaInstalled = new JCheckBox();
        this.javaInstalled.setSelected(bl);
        this.javaInstalled.setMargin(this.defaultInset);
        this.javaInstalled.setEnabled(false);
        if (!bl.booleanValue()) {
            this.javaInstalled.setForeground(new Color(255, 0, 0));
            this.javaInstalled.setText(this.parseText(this.getString("java.not.installed.message")));
            this.parent.lockNextButton();
        } else {
            this.javaInstalled.setForeground(new Color(0, 0, 0));
            this.javaInstalled.setText(this.parseText(this.getString("java.installed.message")));
        }
        this.add((Component)this.javaInstalled, "nextLine");
        this.chromeInstalled = new JCheckBox();
        this.chromeInstalled.setSelected(bl2);
        this.chromeInstalled.setMargin(this.defaultInset);
        this.chromeInstalled.setEnabled(false);
        if (!bl2.booleanValue()) {
            this.chromeInstalled.setForeground(new Color(255, 0, 0));
            this.chromeInstalled.setText(this.parseText(this.getString("chrome.not.installed.message")));
            this.parent.lockNextButton();
        } else {
            this.chromeInstalled.setForeground(new Color(0, 0, 0));
            this.chromeInstalled.setText(this.parseText(this.getString("chrome.installed.message")));
        }
        this.add((Component)this.chromeInstalled, "nextLine");
    }
}

