/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.mandatory;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.JCheckBox;

public class MandatorySoftwarePanel
extends IzPanel {
    private Log myLog;
    private RulesEngine rules;
    private UninstallDataWriter myUninstallDataWriter;
    private JCheckBox codeInstalled;
    private final Insets defaultInset = new Insets(10, 70, 0, 0);

    public MandatorySoftwarePanel(Panel panel, InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources, RulesEngine rulesEngine, UninstallDataWriter uninstallDataWriter, Log log) {
        super(panel, installerFrame, gUIInstallData, new IzPanelLayout(log), resources);
        this.rules = rulesEngine;
        this.myUninstallDataWriter = uninstallDataWriter;
        this.myLog = log;
    }

    @Override
    public void panelActivate() {
        this.configureFields();
        this.getLayoutHelper().completeLayout();
        this.myLog.informUser();
    }

    private void configureFields() {
        Boolean bl = this.rules.isConditionTrue("is.code.installed");
        this.codeInstalled = new JCheckBox();
        this.codeInstalled.setSelected(bl);
        this.codeInstalled.setMargin(this.defaultInset);
        this.codeInstalled.setEnabled(false);
        this.codeInstalled.setForeground(new Color(0, 0, 0));
        if (!bl.booleanValue()) {
            this.codeInstalled.setText(this.parseText(this.getString("code.to.be.installed.message")));
        } else {
            String string = this.getCodeVersion();
            if (string == null) {
                this.codeInstalled.setText(this.parseText(this.getString("code.installed.message.error")));
            } else {
                this.codeInstalled.setText(this.parseText(this.getString("code.installed.message")).replace("${code.version}", string));
            }
        }
        this.add((Component)this.codeInstalled, "nextLine");
    }

    private String getCodeVersion() {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("powershell.exe code -v");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
                System.out.println(string);
            }
            while ((string = bufferedReader2.readLine()) != null) {
                arrayList2.add(string);
                System.out.println(string);
            }
            int n = process.waitFor();
            if (n != 0) {
                return null;
            }
            return (String)arrayList.get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

