/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.htmllicence;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.licence.AbstractLicencePanel;
import com.izforge.izpack.util.HyperlinkHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLLicencePanel
extends AbstractLicencePanel
implements HyperlinkListener,
ActionListener {
    private static final long serialVersionUID = 3256728385458746416L;
    private JEditorPane textArea;
    private final JRadioButton yesRadio;
    private final JRadioButton noRadio;

    public HTMLLicencePanel(Panel panel, final InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources, Log log) {
        super(panel, installerFrame, gUIInstallData, new IzPanelLayout(log), resources);
        Serializable serializable;
        this.add((Component)LabelFactory.create(this.getString("LicencePanel.info"), (Icon)installerFrame.getIcons().get("history"), 10), "nextLine");
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.getDocument().putProperty("stream", null);
            this.textArea.addHyperlinkListener(new HyperlinkHandler());
            serializable = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadLicence());
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JButton jButton = installerFrame.getRootPane().getDefaultButton();
                    if (jButton != null && jButton.isEnabled()) {
                        jButton.doClick();
                    }
                }
            };
            this.textArea.registerKeyboardAction(actionListener, null, KeyStroke.getKeyStroke(10, 0), 0);
            this.add((Component)serializable, "nextLine");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable = new ButtonGroup();
        this.yesRadio = new JRadioButton(this.getString("LicencePanel.agree"), false);
        this.yesRadio.setName(GuiId.LICENCE_YES_RADIO.id);
        ((ButtonGroup)serializable).add(this.yesRadio);
        this.add((Component)this.yesRadio, "nextLine");
        this.yesRadio.addActionListener(this);
        this.noRadio = new JRadioButton(this.getString("LicencePanel.notagree"), true);
        this.noRadio.setName(GuiId.LICENCE_NO_RADIO.id);
        ((ButtonGroup)serializable).add(this.noRadio);
        this.add((Component)this.noRadio, "nextLine");
        this.noRadio.addActionListener(this);
        this.setInitialFocus(this.textArea);
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    @Override
    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    @Override
    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
    }
}

