/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.htmlhello;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.util.HyperlinkHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class HTMLHelloPanel
extends IzPanel {
    private static final long serialVersionUID = -7671648991830935148L;
    protected String panelResourcePrefixStr;
    protected String panelResourceNameStr;
    private JEditorPane textArea;
    private JLabel waitLabel;
    private JScrollPane scroller;
    private Boolean pageLoaded = false;
    private pageLoadListener pListener;
    private String cssLocation = "../../branding/css/SageCss.css";
    private String logoLocation = "../../branding/images/Sage_Logo_Brilliant_Green_RGB (PNG-(Web))-resized.png";

    public HTMLHelloPanel(Panel panel, InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources, Log log) {
        super(panel, installerFrame, gUIInstallData, resources);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(2);
        borderLayout.setVgap(2);
        this.setLayout(borderLayout);
        this.panelResourcePrefixStr = "HTMLHelloPanel";
        this.panelResourceNameStr = "HTMLHelloPanel.info_" + gUIInstallData.getLocaleISO3();
        this.pListener = new pageLoadListener();
        this.waitLabel = new JLabel(this.getString("HelloPanel.waiting"));
        this.waitLabel.setHorizontalAlignment(0);
        this.waitLabel.setVerticalAlignment(0);
        this.waitLabel.setFont(new Font("Arial", 1, 20));
        this.add((Component)this.waitLabel, "Center");
        try {
            this.textArea = new JEditorPane(){
                private static final long serialVersionUID = 1L;

                @Override
                protected InputStream getStream(URL uRL) throws IOException {
                    int n;
                    InputStream inputStream = super.getStream(uRL);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[2048];
                    while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    String string = HTMLHelloPanel.this.parseText(byteArrayOutputStream.toString()).replace(HTMLHelloPanel.this.cssLocation, "SageCss.css").replace(HTMLHelloPanel.this.logoLocation, "SageLogo.png");
                    return new ByteArrayInputStream(string.getBytes());
                }
            };
            this.textArea.addPropertyChangeListener("page", this.pListener);
            this.textArea.setName(GuiId.HTML_INFO_PANEL_TEXT.id);
            this.textArea.setContentType("text/html; charset=utf-8");
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(new HyperlinkHandler());
            this.scroller = new JScrollPane(this.textArea);
            this.textArea.setCaretPosition(0);
            this.add((Component)this.scroller, "North");
            this.textArea.setVisible(false);
            this.scroller.setVisible(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void panelActivate() {
        this.parent.lockNextButton();
        try {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    URL uRL = Thread.currentThread().getContextClassLoader().getResource("resources/" + HTMLHelloPanel.this.panelResourceNameStr);
                    try {
                        HTMLHelloPanel.this.textArea.setPage(uRL);
                        while (!HTMLHelloPanel.this.pageLoaded.booleanValue()) {
                            Thread.sleep(100L);
                        }
                        Dimension dimension = new Dimension((int)HTMLHelloPanel.this.parent.getPanelsContainerSize().getWidth(), (int)HTMLHelloPanel.this.parent.getPanelsContainerSize().getHeight() - 15);
                        HTMLHelloPanel.this.textArea.setBounds(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
                        HTMLHelloPanel.this.textArea.setSize(dimension);
                        HTMLHelloPanel.this.textArea.setMaximumSize(dimension);
                        HTMLHelloPanel.this.textArea.setPreferredSize(dimension);
                        HTMLHelloPanel.this.textArea.setVisible(true);
                        HTMLHelloPanel.this.scroller.setVisible(true);
                        HTMLHelloPanel.this.textArea.setCaretPosition(0);
                        HTMLHelloPanel.this.waitLabel.setVisible(false);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    finally {
                        HTMLHelloPanel.this.parent.unlockNextButton();
                    }
                }
            };
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class pageLoadListener
    implements PropertyChangeListener {
        private pageLoadListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HTMLHelloPanel.this.pageLoaded = true;
        }
    }
}

