/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.provider;

import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackInfo;
import com.izforge.izpack.api.data.Value;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.TemporaryDirectory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.picocontainer.injectors.Provider;

public abstract class AbstractInstallDataProvider
implements Provider {
    private static final Logger logger = Logger.getLogger(AbstractInstallDataProvider.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInstallData(AutomatedInstallData installData, Resources resources, PlatformModelMatcher matcher, Housekeeper housekeeper) throws IOException, ClassNotFoundException {
        List packs;
        Info info = (Info)resources.getObject("info");
        installData.setVariable("APP_NAME", info.getAppName());
        if (info.getAppURL() != null) {
            installData.setVariable("APP_URL", info.getAppURL());
        }
        installData.setVariable("APP_VER", info.getAppVersion());
        if (info.getUninstallerCondition() != null) {
            installData.setVariable("UNINSTALLER_CONDITION", info.getUninstallerCondition());
        }
        installData.setInfo(info);
        String dir = this.getDir(resources);
        String installPath = dir + info.getAppName();
        if (info.getInstallationSubPath() != null) {
            installPath = IoHelper.translatePath(dir + info.getInstallationSubPath(), installData.getVariables());
        }
        installData.setDefaultInstallPath(installPath);
        installPath = System.getProperty("INSTALL_PATH");
        if (installPath != null) {
            installData.setInstallPath(installPath);
        }
        List panelsOrder = (List)resources.getObject("panelsOrder");
        InputStream in = resources.getInputStream("packs.info");
        ObjectInputStream objIn = new ObjectInputStream(in);
        try {
            packs = (List)objIn.readObject();
        }
        finally {
            IOUtils.closeQuietly(objIn);
        }
        ArrayList<Pack> availablePacks = new ArrayList<Pack>();
        ArrayList<Pack> allPacks = new ArrayList<Pack>();
        for (PackInfo packInfo : packs) {
            Pack pack = packInfo.getPack();
            allPacks.add(pack);
            if (!matcher.matchesCurrentPlatform(pack.getOsConstraints())) continue;
            availablePacks.add(pack);
        }
        this.setStandardVariables(installData, dir);
        Properties properties = (Properties)resources.getObject("vars");
        if (properties != null) {
            Set<String> vars = properties.stringPropertyNames();
            for (String varName : vars) {
                installData.setVariable(varName, properties.getProperty(varName));
            }
        }
        installData.setPanelsOrder(panelsOrder);
        installData.setAvailablePacks(availablePacks);
        installData.setAllPacks(allPacks);
        for (Pack availablePack : availablePacks) {
            if (!availablePack.isPreselected()) continue;
            installData.getSelectedPacks().add(availablePack);
        }
        Set<Info.TempDir> tempDirs = info.getTempDirs();
        if (null != tempDirs && tempDirs.size() > 0) {
            for (Info.TempDir tempDir : tempDirs) {
                TemporaryDirectory directory = new TemporaryDirectory(tempDir, installData, housekeeper);
                directory.create();
                directory.deleteOnExit();
            }
        }
    }

    protected void setStandardVariables(AutomatedInstallData installData, String dir) {
        String hostname;
        String IPAddress;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            IPAddress = localHost.getHostAddress();
            hostname = localHost.getHostName();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to determine hostname and IP address", exception);
            hostname = "";
            IPAddress = "";
        }
        installData.setVariable("APPLICATIONS_DEFAULT_ROOT", dir);
        installData.setVariable("JAVA_HOME", System.getProperty("java.home"));
        installData.setVariable("CLASS_PATH", System.getProperty("java.class.path"));
        installData.setVariable("USER_HOME", System.getProperty("user.home"));
        installData.setVariable("USER_NAME", System.getProperty("user.name"));
        installData.setVariable("IP_ADDRESS", IPAddress);
        installData.setVariable("HOST_NAME", hostname);
        installData.setVariable("FILE_SEPARATOR", File.separator);
    }

    public static void addCustomLangpack(AutomatedInstallData installData, Locales locales) {
        try {
            installData.getMessages().add(locales.getMessages("CustomLangPack.xml"));
            logger.fine("Found custom langpack for " + installData.getLocaleISO3());
        }
        catch (ResourceNotFoundException exception) {
            logger.fine("No custom langpack for " + installData.getLocaleISO3() + " available");
        }
    }

    private String getDir(Resources resources) {
        String dir = OsVersion.IS_WINDOWS ? this.buildWindowsDefaultPath(resources) : (OsVersion.IS_OSX ? "/Applications/" : (new File("/usr/local/").canWrite() ? "/usr/local/" : System.getProperty("user.home") + File.separatorChar));
        return dir;
    }

    private String buildWindowsDefaultPath(Resources resources) {
        try {
            String prgFilesPath = IoHelper.getenv("ProgramFiles");
            if (prgFilesPath != null && prgFilesPath.length() > 0) {
                return prgFilesPath + File.separatorChar;
            }
            return this.buildWindowsDefaultPathFromProps(resources);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
            return this.buildWindowsDefaultPathFromProps(resources);
        }
    }

    private String buildWindowsDefaultPathFromProps(Resources resources) {
        StringBuilder result = new StringBuilder("");
        try {
            Properties props = new Properties();
            props.load(resources.getInputStream("/com/izforge/izpack/installer/win32-defaultpaths.properties"));
            String drive = System.getProperty("user.home");
            if (drive.length() > 3) {
                drive = drive.substring(0, 3);
            }
            result.append(drive);
            if (drive.length() == 2) {
                result.append("\\");
            }
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String language_country = language + "_" + country;
            if (null != props.getProperty(language_country)) {
                result.append(props.getProperty(language_country));
            } else if (null != props.getProperty(language)) {
                result.append(props.getProperty(language));
            } else {
                result.append(props.getProperty(Locale.ENGLISH.getLanguage()));
            }
        }
        catch (Exception err) {
            result = new StringBuilder("C:\\Program Files");
        }
        return result.toString();
    }

    protected void loadDynamicVariables(Variables variables, InstallData installData, Resources resources) {
        try {
            List dynamicVariables = (List)resources.getObject("dynvariables");
            for (DynamicVariable dynamic : dynamicVariables) {
                Value value = dynamic.getValue();
                value.setInstallData(installData);
                variables.add(dynamic);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot find optional dynamic variables", e);
        }
    }

    protected void loadDynamicConditions(AutomatedInstallData installData, Resources resources) {
        try {
            List conditions = (List)resources.getObject("dynconditions");
            installData.setDynamicInstallerRequirements(conditions);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot find optional dynamic conditions", e);
        }
    }

    protected void loadInstallerRequirements(AutomatedInstallData installData, Resources resources) {
        List requirements = (List)resources.getObject("installerrequirements");
        installData.setInstallerRequirements(requirements);
    }

    protected void loadDefaultLocale(AutomatedInstallData installData, Locales locales) {
        Locale locale = locales.getLocale();
        if (locale != null) {
            installData.setInstallationRecord(new XMLElementImpl("AutomatedInstallation"));
            installData.setLocale(locale, locales.getISOCode());
            installData.setMessages(locales.getMessages());
        }
    }
}

