/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.XMLException;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.adaptator.impl.XMLWriter;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.ConditionReference;
import com.izforge.izpack.api.rules.ConditionWithMultipleOperands;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.rules.ConditionContainer;
import com.izforge.izpack.core.rules.logic.AndCondition;
import com.izforge.izpack.core.rules.logic.NotCondition;
import com.izforge.izpack.core.rules.logic.OrCondition;
import com.izforge.izpack.core.rules.logic.XorCondition;
import com.izforge.izpack.core.rules.process.CompareNumericsCondition;
import com.izforge.izpack.core.rules.process.CompareVersionsCondition;
import com.izforge.izpack.core.rules.process.CompareVersionsMajorCondition;
import com.izforge.izpack.core.rules.process.ContainsCondition;
import com.izforge.izpack.core.rules.process.EmptyCondition;
import com.izforge.izpack.core.rules.process.ExistsCondition;
import com.izforge.izpack.core.rules.process.JavaCondition;
import com.izforge.izpack.core.rules.process.PackSelectionCondition;
import com.izforge.izpack.core.rules.process.RefCondition;
import com.izforge.izpack.core.rules.process.UserCondition;
import com.izforge.izpack.core.rules.process.VariableCondition;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class RulesEngineImpl
implements RulesEngine {
    private final Map<String, String> panelConditions = new HashMap<String, String>();
    private final Map<String, String> packConditions = new HashMap<String, String>();
    private final Map<String, String> optionalPackConditions = new HashMap<String, String>();
    private final Map<String, Condition> conditionsMap = new HashMap<String, Condition>();
    private final Set<ConditionReference> refConditions = new HashSet<ConditionReference>();
    private final InstallData installData;
    private final ConditionContainer container;
    private static final Logger logger = Logger.getLogger(RulesEngineImpl.class.getName());
    private static final Map<String, String> TYPE_CLASS_NAMES = new HashMap<String, String>();

    public RulesEngineImpl(ConditionContainer container, Platform platform) {
        this.installData = null;
        this.container = container;
        this.initStandardConditions(platform);
    }

    public RulesEngineImpl(InstallData installData, ConditionContainer container, Platform platform) {
        this.installData = installData;
        this.container = container;
        if (installData != null) {
            this.initStandardConditions(platform);
        }
    }

    @Override
    public void readConditionMap(Map<String, Condition> rules) {
        for (Map.Entry<String, Condition> entry : rules.entrySet()) {
            Condition condition = entry.getValue();
            if (condition instanceof BuiltinCondition) continue;
            this.conditionsMap.put(entry.getKey(), condition);
            condition.setInstallData(this.installData);
            this.resolveBuiltinConditions(condition);
        }
    }

    @Override
    public Set<String> getKnownConditionIds() {
        return this.conditionsMap.keySet();
    }

    @Override
    public Condition createCondition(IXMLElement condition, Class<Condition> conditionClass) {
        String id = condition.getAttribute("id");
        String type = condition.getAttribute("type");
        Condition result = null;
        if (type != null) {
            String className = this.getClassName(type);
            if (conditionClass == null) {
                conditionClass = this.container.getClass(className, Condition.class);
            }
            try {
                if (id == null || id.isEmpty() || "UNKNOWN".equals(id)) {
                    id = className + "-" + UUID.randomUUID().toString();
                    logger.fine("Random condition id " + id + " generated");
                }
                this.container.addComponent(id, conditionClass);
                result = (Condition)this.container.getComponent(id);
                result.setId(id);
                result.setInstallData(this.installData);
                result.readFromXML(condition);
                this.conditionsMap.put(id, result);
                if (result instanceof ConditionReference) {
                    this.refConditions.add((ConditionReference)result);
                }
            }
            catch (Exception e) {
                throw new IzPackException(e);
            }
        }
        return result;
    }

    @Override
    public Condition createCondition(IXMLElement condition) {
        return this.createCondition(condition, null);
    }

    @Override
    public void resolveConditions() {
        for (ConditionReference refCondition : this.refConditions) {
            refCondition.resolveReference();
        }
    }

    @Override
    public void analyzeXml(IXMLElement conditionsSpec) {
        if (conditionsSpec == null) {
            logger.fine("No conditions specification found");
            return;
        }
        if (conditionsSpec.hasChildren()) {
            List<IXMLElement> childs = conditionsSpec.getChildrenNamed("condition");
            for (IXMLElement condition : childs) {
                Condition cond = this.createCondition(condition);
                if (cond == null || cond instanceof BuiltinCondition) continue;
                String condid = cond.getId();
                cond.setInstallData(this.installData);
                if (condid == null || "UNKNOWN".equals(condid)) continue;
                this.resolveBuiltinConditions(cond);
                this.conditionsMap.put(condid, cond);
            }
            List<IXMLElement> panelconditionels = conditionsSpec.getChildrenNamed("panelcondition");
            for (IXMLElement panelel : panelconditionels) {
                String panelid = panelel.getAttribute("panelid");
                String conditionid = panelel.getAttribute("conditionid");
                this.panelConditions.put(panelid, conditionid);
            }
            List<IXMLElement> packconditionels = conditionsSpec.getChildrenNamed("packcondition");
            for (IXMLElement panelel : packconditionels) {
                boolean optionalinstall;
                String panelid = panelel.getAttribute("packid");
                String conditionid = panelel.getAttribute("conditionid");
                this.packConditions.put(panelid, conditionid);
                String optional = panelel.getAttribute("optional");
                if (optional == null || !(optionalinstall = Boolean.valueOf(optional).booleanValue())) continue;
                this.optionalPackConditions.put(panelid, conditionid);
            }
        }
    }

    @Override
    public Condition getCondition(String id) {
        Condition result = this.conditionsMap.get(id);
        if (result == null) {
            result = id.startsWith("@") ? this.parseComplexCondition(id.substring(1)) : this.getConditionByExpr(new StringBuffer(id));
        }
        return result;
    }

    @Override
    public boolean isConditionTrue(String id, InstallData installData) {
        Condition cond = this.getCondition(id);
        if (cond != null) {
            return this.isConditionTrue(cond, installData);
        }
        throw new IzPackException("Condition " + id + " not found");
    }

    @Override
    public boolean isConditionTrue(Condition cond, InstallData installData) {
        if (cond != null) {
            if (installData != null) {
                cond.setInstallData(installData);
            }
            return this.isConditionTrue(cond);
        }
        return false;
    }

    @Override
    public boolean isConditionTrue(String id) {
        Condition cond = this.getCondition(id);
        if (cond != null) {
            return this.isConditionTrue(cond);
        }
        logger.warning("Condition " + id + " not found");
        return false;
    }

    @Override
    public boolean isConditionTrue(Condition cond) {
        if (cond.getInstallData() == null) {
            cond.setInstallData(this.installData);
        }
        return cond.isTrue();
    }

    @Override
    public boolean canShowPanel(String panelId, Variables variables) {
        if (!this.panelConditions.containsKey(panelId)) {
            logger.fine("Panel " + panelId + " unconditionally activated");
            return true;
        }
        Condition condition = this.getCondition(this.panelConditions.get(panelId));
        boolean b = condition.isTrue();
        logger.fine("Panel " + panelId + ": activation depends on condition " + condition.getId() + " -> " + b);
        return b;
    }

    @Override
    public void addPanelCondition(Panel panel, Condition newCondition) {
        String panelId = panel.getPanelId();
        String panelCondString = panel.getCondition();
        if (panelCondString != null) {
            Condition panelCondition = this.getCondition(panelCondString);
            if (panelCondition == null) {
                throw new IzPackException("Condition '" + panelCondString + "' of panel '" + panel.getPanelId() + "'" + "cannot be evaluated");
            }
            AndCondition andCondition = new AndCondition(this);
            andCondition.setId(andCondition.toString());
            andCondition.addOperands(newCondition);
            andCondition.addOperands(panelCondition);
            newCondition = andCondition;
        }
        this.addCondition(newCondition);
        panel.setCondition(newCondition.getId());
        this.panelConditions.put(panelId, newCondition.getId());
    }

    @Override
    public boolean canInstallPack(String packid, Variables variables) {
        if (packid == null) {
            return true;
        }
        if (!this.packConditions.containsKey(packid)) {
            logger.fine("Package " + packid + " unconditionally installable");
            return true;
        }
        Condition condition = this.getCondition(this.packConditions.get(packid));
        boolean b = condition.isTrue();
        logger.fine("Package " + packid + ": installation depends on condition " + condition.getId() + " -> " + b);
        return b;
    }

    @Override
    public boolean canInstallPackOptional(String packid, Variables variables) {
        if (!this.optionalPackConditions.containsKey(packid)) {
            logger.fine("Package " + packid + " unconditionally installable");
            return false;
        }
        logger.fine("Package " + packid + " optional installation possible");
        return true;
    }

    @Override
    public void addCondition(Condition condition) {
        if (condition != null) {
            String id = condition.getId();
            if (this.conditionsMap.containsKey(id)) {
                logger.warning("Condition " + id + " already registered");
            } else {
                this.conditionsMap.put(id, condition);
            }
        } else {
            logger.warning("Could not add condition, was null");
        }
    }

    @Override
    public void writeRulesXML(OutputStream out) {
        XMLWriter xmlOut = new XMLWriter();
        xmlOut.setOutput(out);
        XMLElementImpl conditionsel = new XMLElementImpl("conditions");
        for (Condition condition : this.conditionsMap.values()) {
            IXMLElement conditionEl = this.createConditionElement(condition, conditionsel);
            condition.makeXMLData(conditionEl);
            conditionsel.addChild(conditionEl);
        }
        logger.fine("Writing generated conditions specification");
        try {
            xmlOut.write(conditionsel);
        }
        catch (XMLException e) {
            throw new IzPackException(e);
        }
    }

    @Override
    public IXMLElement createConditionElement(Condition condition, IXMLElement root) {
        XMLElementImpl xml = new XMLElementImpl("condition", root);
        xml.setAttribute("id", condition.getId());
        xml.setAttribute("type", condition.getClass().getCanonicalName());
        return xml;
    }

    private void initStandardConditions(Platform platform) {
        logger.fine("Initializing built-in conditions");
        this.initOsConditions(platform);
        if (this.installData != null && this.installData.getAllPacks() != null) {
            logger.fine("Initializing built-in conditions for packs");
            for (Pack pack : this.installData.getAllPacks()) {
                PackSelectionCondition selectionCondition = new PackSelectionCondition();
                selectionCondition.setInstallData(this.installData);
                selectionCondition.setId("izpack.selected." + pack.getName());
                selectionCondition.setPack(pack.getName());
                this.conditionsMap.put(selectionCondition.getId(), selectionCondition);
                String condition = pack.getCondition();
                if (condition == null || condition.isEmpty()) continue;
                logger.fine("Adding pack condition \"" + condition + "\" for pack \"" + pack.getName() + "\"");
                this.packConditions.put(pack.getName(), condition);
            }
        }
    }

    private void initOsConditions(Platform platform) {
        this.createPlatformCondition("izpack.aixinstall", platform, Platforms.AIX);
        this.createPlatformCondition("izpack.windowsinstall", platform, Platforms.WINDOWS);
        this.createPlatformCondition("izpack.windowsinstall.xp", platform, Platforms.WINDOWS_XP);
        this.createPlatformCondition("izpack.windowsinstall.2003", platform, Platforms.WINDOWS_2003);
        this.createPlatformCondition("izpack.windowsinstall.vista", platform, Platforms.WINDOWS_VISTA);
        this.createPlatformCondition("izpack.windowsinstall.7", platform, Platforms.WINDOWS_7);
        this.createPlatformCondition("izpack.windowsinstall.8", platform, Platforms.WINDOWS_8);
        this.createPlatformCondition("izpack.windowsinstall.10", platform, Platforms.WINDOWS_10);
        this.createPlatformCondition("izpack.linuxinstall", platform, Platforms.LINUX);
        this.createPlatformCondition("izpack.solarisinstall", platform, Platforms.SUNOS);
        this.createPlatformCondition("izpack.macinstall", platform, Platforms.MAC);
        this.createPlatformCondition("izpack.macinstall.osx", platform, Platforms.MAC_OSX);
        this.createPlatformCondition("izpack.solarisinstall.x86", platform, Platforms.SUNOS_X86);
        this.createPlatformCondition("izpack.solarisinstall.sparc", platform, Platforms.SUNOS_SPARC);
    }

    private void createPlatformCondition(String conditionId, Platform current, Platform platform) {
        boolean isA = current.isA(platform);
        StaticCondition condition = new StaticCondition(isA);
        condition.setInstallData(this.installData);
        condition.setId(conditionId);
        this.conditionsMap.put(condition.getId(), condition);
    }

    private Condition parseComplexCondition(String expression) {
        Condition result = expression.contains("||") ? this.parseComplexOrCondition(expression) : (expression.contains("&&") ? this.parseComplexAndCondition(expression) : (expression.contains("^") ? this.parseComplexXorCondition(expression) : (expression.contains("!") ? this.parseComplexNotCondition(expression) : this.conditionsMap.get(expression))));
        if (result != null) {
            result.setInstallData(this.installData);
        }
        return result;
    }

    private Condition parseComplexOrCondition(String expression) {
        String[] parts = expression.split("\\|\\|", 2);
        return this.evaluateComplexExpression("or", expression, parts);
    }

    private Condition parseComplexXorCondition(String expression) {
        String[] parts = expression.split("\\^", 2);
        return this.evaluateComplexExpression("xor", expression, parts);
    }

    private Condition parseComplexAndCondition(String expression) {
        String[] parts = expression.split("&&", 2);
        return this.evaluateComplexExpression("and", expression, parts);
    }

    private Condition parseComplexNotCondition(String expression) {
        Condition result = NotCondition.createFromCondition(this.parseComplexCondition(expression.substring(1).trim()), this);
        return result;
    }

    private Condition getConditionByExpr(StringBuffer conditionexpr) {
        Condition result = null;
        block6: for (int index = 0; index < conditionexpr.length(); ++index) {
            char currentchar = conditionexpr.charAt(index);
            switch (currentchar) {
                case '+': {
                    result = this.evaluateSimpleExpression("and", conditionexpr, index);
                    continue block6;
                }
                case '|': {
                    result = this.evaluateSimpleExpression("or", conditionexpr, index);
                    continue block6;
                }
                case '\\': {
                    result = this.evaluateSimpleExpression("xor", conditionexpr, index);
                    continue block6;
                }
                case '!': {
                    if (index > 0) {
                        logger.warning("! operator only allowed at position 0");
                        continue block6;
                    }
                    conditionexpr.deleteCharAt(index);
                    result = NotCondition.createFromCondition(this.getConditionByExpr(conditionexpr), this);
                    continue block6;
                }
            }
        }
        if (conditionexpr.length() > 0 && (result = this.conditionsMap.get(conditionexpr.toString())) != null) {
            result.setInstallData(this.installData);
            conditionexpr.delete(0, conditionexpr.length());
        }
        return result;
    }

    private Condition evaluateSimpleExpression(String condType, StringBuffer expression, int index) {
        Condition result = this.instantiateConditionClass(condType);
        String warningMsg = "Condition: %s contains reference to undefined condition: %s";
        String conditionId = expression.toString();
        String operand1Id = expression.substring(0, index);
        Condition operand1 = this.conditionsMap.get(operand1Id);
        if (operand1 != null) {
            expression.delete(0, index + 1);
            String operand2Id = expression.toString();
            Condition operand2 = this.getConditionByExpr(expression);
            if (operand2 != null) {
                assert (result != null);
                ((ConditionWithMultipleOperands)result).addOperands(operand1, operand2);
            } else {
                logger.warning(String.format(warningMsg, conditionId, operand2Id));
                result = null;
            }
        } else {
            logger.warning(String.format(warningMsg, conditionId, operand1Id));
            result = null;
        }
        return result;
    }

    private Condition evaluateComplexExpression(String condType, String expression, String[] parts) {
        String warning = "Complex condition: " + expression + " contains reference to undefined condition: %s";
        Condition result = this.instantiateConditionClass(condType);
        String operand1Id = parts[0].trim();
        String operand2Id = parts[1].trim();
        Condition operand1 = this.parseComplexCondition(operand1Id);
        Condition operand2 = this.parseComplexCondition(operand2Id);
        if (operand1 == null) {
            logger.warning(String.format(warning, operand1Id));
            return null;
        }
        if (operand2 == null) {
            logger.warning(String.format(warning, operand2Id));
            return null;
        }
        assert (result != null);
        ((ConditionWithMultipleOperands)result).addOperands(operand1, operand2);
        return result;
    }

    private Condition instantiateConditionClass(String condType) {
        Condition result;
        String condClassName = this.getClassName(condType);
        try {
            Class<?> conditionClass = Class.forName(condClassName);
            Constructor<?> constructor = conditionClass.getConstructor(RulesEngine.class);
            result = (Condition)constructor.newInstance(this);
        }
        catch (ClassNotFoundException e) {
            logger.warning("Condition class not found: " + condClassName);
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.warning("Condition: " + condClassName + " is missing a constructor with a RulesEngine parameter");
            return null;
        }
        catch (InvocationTargetException e) {
            logger.warning("Condition: " + condClassName + " constructor threw an exception.");
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            logger.warning("Attempting to instantiate condition: " + condClassName + " failed. It could be an abstract class");
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            logger.warning("Access to condition: " + condClassName + " constructor was denied");
            e.printStackTrace();
            return null;
        }
        return result;
    }

    @Override
    public String getClassName(String type) {
        String result;
        if (type.indexOf(46) != -1) {
            result = type;
        } else {
            result = TYPE_CLASS_NAMES.get(type);
            if (result == null) {
                result = type;
            }
        }
        return result;
    }

    private void resolveBuiltinConditions(Condition condition) {
        if (condition instanceof ConditionReference) {
            ConditionReference not = (ConditionReference)condition;
            if (not.getReferencedCondition() instanceof StaticCondition) {
                not.setReferencedCondition(this.conditionsMap.get(not.getReferencedCondition().getId()));
            } else {
                this.resolveBuiltinConditions(not.getReferencedCondition());
            }
        } else if (condition instanceof ConditionWithMultipleOperands) {
            ConditionWithMultipleOperands c = (ConditionWithMultipleOperands)condition;
            List<Condition> operands = c.getOperands();
            for (int i = 0; i < operands.size(); ++i) {
                Condition operand = operands.get(i);
                if (operand instanceof StaticCondition) {
                    operands.set(i, this.conditionsMap.get(operand.getId()));
                    continue;
                }
                this.resolveBuiltinConditions(operand);
            }
        }
    }

    static {
        TYPE_CLASS_NAMES.put("and", AndCondition.class.getName());
        TYPE_CLASS_NAMES.put("not", NotCondition.class.getName());
        TYPE_CLASS_NAMES.put("or", OrCondition.class.getName());
        TYPE_CLASS_NAMES.put("xor", XorCondition.class.getName());
        TYPE_CLASS_NAMES.put("comparenumerics", CompareNumericsCondition.class.getName());
        TYPE_CLASS_NAMES.put("compareversions", CompareVersionsCondition.class.getName());
        TYPE_CLASS_NAMES.put("compareversionsmajor", CompareVersionsMajorCondition.class.getName());
        TYPE_CLASS_NAMES.put("empty", EmptyCondition.class.getName());
        TYPE_CLASS_NAMES.put("exists", ExistsCondition.class.getName());
        TYPE_CLASS_NAMES.put("contains", ContainsCondition.class.getName());
        TYPE_CLASS_NAMES.put("java", JavaCondition.class.getName());
        TYPE_CLASS_NAMES.put("packselection", PackSelectionCondition.class.getName());
        TYPE_CLASS_NAMES.put("ref", RefCondition.class.getName());
        TYPE_CLASS_NAMES.put("user", UserCondition.class.getName());
        TYPE_CLASS_NAMES.put("variable", VariableCondition.class.getName());
    }

    private static class StaticCondition
    extends BuiltinCondition {
        private static final long serialVersionUID = 1L;
        private final boolean result;

        public StaticCondition(boolean result) {
            this.result = result;
        }

        @Override
        public boolean isTrue() {
            return this.result;
        }

        @Override
        public Set<String> getVarRefs() {
            return new HashSet<String>(0);
        }
    }

    private static abstract class BuiltinCondition
    extends Condition {
        private static final long serialVersionUID = 1L;

        private BuiltinCondition() {
        }

        @Override
        public void readFromXML(IXMLElement condition) throws Exception {
        }

        @Override
        public void makeXMLData(IXMLElement conditionRoot) {
        }
    }
}

