/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValueUtils {
    private static final Pattern RESOLVER_PATTERN = Pattern.compile("\\$\\{(.+?)\\}|\\$(.+?)\\b");

    public static Set<String> parseUnresolvedVariableNames(String ... strings) {
        HashSet<String> unresolvedNames = new HashSet<String>();
        for (String s : strings) {
            if (s == null) continue;
            Matcher matcher = RESOLVER_PATTERN.matcher(s);
            while (matcher.find()) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    String name = matcher.group(i + 1);
                    if (name == null) continue;
                    unresolvedNames.add(name);
                }
            }
        }
        return unresolvedNames;
    }

    private static Matcher getUnresolvedVariableMatcher(String value) {
        return RESOLVER_PATTERN.matcher(value);
    }

    public static boolean isUnresolved(String value) {
        Matcher matcher = ValueUtils.getUnresolvedVariableMatcher(value);
        return matcher.find();
    }
}

