/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.validators;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NexusConnectionValidator
implements DataValidator {
    protected InstallData installData;
    protected String str_errorMsg;
    protected String str_warningMsg = "";

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        this.installData = installData;
        try {
            String string = this.installData.getVariable("atp.user.name");
            String string2 = this.installData.getVariable("atp.user.password");
            String string3 = this.installData.getVariable("TEMP_DIRECTORY") + "/scripts/nexusLogin.ps1";
            String string4 = "@sageatp";
            String string5 = this.installData.getVariable("update.password");
            if (this.installData.getRules().isConditionTrue("test.mode")) {
                string4 = "@sageatptest";
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("powershell.exe");
            arrayList.add(string3);
            arrayList.add("-username '" + string + "'");
            arrayList.add("-password '" + string2 + "'");
            arrayList.add("-scope '" + string4 + "'");
            if (string5 == "true") {
                arrayList.add("-newPassword");
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string6 = null;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            while ((string6 = bufferedReader.readLine()) != null) {
                arrayList2.add(string6);
                System.out.println(string6);
            }
            while ((string6 = bufferedReader2.readLine()) != null) {
                arrayList3.add(string6);
                System.out.println(string6);
            }
            int n = process.waitFor();
            if (n != 0) {
                this.str_errorMsg = this.checkOutputLoginFailure(arrayList3) || this.checkOutputLoginFailure(arrayList2) ? "Incorrect username or password, please try again." : "Sage Nexus NPM repository couldn't be reached.\nPlease contact your local IT to verify you can use internet port 8443.\n" + ((Object)arrayList3).toString();
                return DataValidator.Status.ERROR;
            }
        }
        catch (Exception exception) {
            this.str_errorMsg = "Unable to connect due to the following error:\n" + exception.getLocalizedMessage();
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return this.str_errorMsg;
    }

    @Override
    public String getWarningMessageId() {
        return this.str_warningMsg;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    private boolean checkOutputLoginFailure(List<String> list) {
        String[] stringArray = new String[]{"incorrect username or password", "bad username or password", "unable to authenticate", "eneedauth"};
        for (String string : list) {
            if (!Arrays.stream(stringArray).anyMatch(string.toLowerCase()::contains)) continue;
            return true;
        }
        return false;
    }
}

