/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.simplefinish;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class SimpleFinishPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3689911781942572085L;
    private UninstallDataWriter uninstallDataWriter;
    private final Log log;
    private JButton launchVSCodeButton;

    public SimpleFinishPanel(Panel panel, InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources, UninstallDataWriter uninstallDataWriter, Log log) {
        super(panel, installerFrame, gUIInstallData, new IzPanelLayout(log), resources);
        this.uninstallDataWriter = uninstallDataWriter;
        this.log = log;
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        if (this.installData.isInstallSuccess()) {
            this.add(LabelFactory.create((Icon)this.parent.getIcons().get("check")));
            this.add(IzPanelLayout.createVerticalStrut(5));
            JLabel jLabel = LabelFactory.create(this.getString("FinishPanel.success"), (Icon)this.parent.getIcons().get("preferences"), 10);
            jLabel.setName(GuiId.SIMPLE_FINISH_LABEL.id);
            this.add((Component)jLabel, "nextLine");
            this.add(IzPanelLayout.createVerticalStrut(5));
            if (this.uninstallDataWriter.isUninstallRequired()) {
                String string = this.translatePath(this.installData.getInfo().getUninstallerPath());
                JLabel jLabel2 = LabelFactory.create(this.getString("FinishPanel.uninst.info"), (Icon)this.parent.getIcons().get("preferences"), 10);
                jLabel2.setName(GuiId.SIMPLE_FINISH_UNINSTALL_LABEL.id);
                this.add((Component)jLabel2, "nextLine");
                this.add((Component)LabelFactory.create(string, (Icon)this.parent.getIcons().get("empty"), 10), "nextLine");
            }
            this.add(IzPanelLayout.createVerticalStrut(5));
            this.launchVSCodeButton = ButtonFactory.createButton(this.getString("launch.vscode.button.text"), (Icon)this.parent.getIcons().get("edit"), this.installData.buttonsHColor);
            this.launchVSCodeButton.setToolTipText(this.getString("launch.vscode.button.tip"));
            this.launchVSCodeButton.addActionListener(this);
            this.add((Component)this.launchVSCodeButton, "nextLine");
        } else {
            this.add(LabelFactory.create(this.getString("FinishPanel.fail"), (Icon)this.parent.getIcons().get("stop"), 10));
        }
        this.getLayoutHelper().completeLayout();
        this.log.informUser();
    }

    private String translatePath(String string) {
        string = this.installData.getVariables().replace(string);
        return string.replace('/', File.separatorChar);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Runtime.getRuntime().exec("explorer.exe /e, " + this.installData.getInstallPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

