/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.atpsummary;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.MultiLineLabel;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.sage.izpack.VersionUtilities.VersionState;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ATPSummaryPanel
extends IzPanel {
    private Log myLog;
    private RulesEngine rules;
    private UninstallDataWriter myUninstallDataWriter;
    private JLabel installType;
    private JLabel installLocation;
    private Component topSeparatorStrut;
    private JLabel codeInstallation;
    private JLabel gitInstallation;
    private Component bottomSeparatorStrut = IzPanelLayout.createVerticalStrut(10);
    private JLabel nextToInstallMessage;
    private MultiLineLabel debugMessage;
    private String debugString = "";
    private final Border paddingBorder = BorderFactory.createEmptyBorder(0, 150, 0, 150);

    public ATPSummaryPanel(Panel panel, InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources, RulesEngine rulesEngine, UninstallDataWriter uninstallDataWriter, Log log) {
        super(panel, installerFrame, gUIInstallData, new IzPanelLayout(log), resources);
        this.rules = rulesEngine;
        this.myUninstallDataWriter = uninstallDataWriter;
        this.myLog = log;
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        try {
            this.clean();
        }
        catch (Exception exception) {
            this.debugMessage = new MultiLineLabel(this.debugString + "\n" + exception.getMessage());
            this.add(this.debugMessage);
        }
        try {
            this.checkUpgradeInfo();
        }
        catch (Exception exception) {
            this.debugMessage = new MultiLineLabel(this.debugString + "\n" + exception.getMessage());
            this.add(this.debugMessage);
        }
        try {
            this.configureFields();
        }
        catch (Exception exception) {
            this.debugMessage = new MultiLineLabel(this.debugString + "\n" + exception.getMessage());
            this.add(this.debugMessage);
        }
        String string = this.getString("SummaryPanel.next");
        if (string == null) {
            string = this.getString("installer.next");
        }
        this.parent.getNavigator().setNextText(string);
        this.getLayoutHelper().completeLayout();
        this.myLog.informUser();
    }

    private void clean() {
        if (this.installType == null) {
            return;
        }
        this.remove(this.installType);
        this.remove(this.installLocation);
        if (this.topSeparatorStrut != null) {
            this.remove(this.topSeparatorStrut);
        }
        if (this.codeInstallation != null) {
            this.remove(this.codeInstallation);
        }
        if (this.gitInstallation != null) {
            this.remove(this.gitInstallation);
        }
        this.remove(this.bottomSeparatorStrut);
        this.remove(this.nextToInstallMessage);
        this.getLayoutHelper().startLayout(new IzPanelLayout(this.myLog));
    }

    private void checkUpgradeInfo() {
        this.debugString = this.debugString + "\n check install path for upgrade";
        if (this.rules.isConditionTrue("is.upgrade") && this.installData.getInstallPath() == null) {
            this.installData.setInstallPath(this.installData.getVariable("atp.install.directory.windows"));
        }
        this.debugString = this.debugString + "\n check if package.json exists in the folder";
        Path path = Paths.get(this.installData.getInstallPath(), "package.json");
        if (path.toFile().exists() && !this.rules.isConditionTrue("is.upgrade")) {
            this.debugString = this.debugString + "\n Get atp version from node";
            String string = "";
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("cmd.exe");
                arrayList.add("/c");
                arrayList.add("node -e \"console.log(require('./package.json').version);\"");
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                processBuilder.directory(new File(this.installData.getInstallPath()));
                Process process = processBuilder.start();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String string2 = null;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList2.add(string2);
                    System.out.println(string2);
                }
                while ((string2 = bufferedReader2.readLine()) != null) {
                    arrayList3.add(string2);
                    System.out.println(string2);
                }
                int n = process.waitFor();
                if (n != 0) {
                    this.debugString = this.debugString + "\n" + ((Object)arrayList3).toString();
                } else {
                    this.debugString = this.debugString + "\n set variable and resolve conditions";
                    string = (String)arrayList2.get(0);
                    this.installData.setVariable("atp.version.installed", string);
                    this.rules.resolveConditions();
                }
            }
            catch (Exception exception) {
                this.debugString = this.debugString + "\n" + exception.getLocalizedMessage();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void configureFields() {
        this.rules.resolveConditions();
        this.installType = new JLabel();
        this.installType.setBorder(this.paddingBorder);
        if (this.rules.isConditionTrue("is.upgrade")) {
            this.debugString = this.debugString + "\n checking version numbers";
            VersionState versionState = new VersionState().versionComparison(this.installData.getVariable("atp.version.installed"), this.installData.getInfo().getAppVersion());
            this.debugString = this.debugString + "\n Version is " + versionState.overallVersionIs.toString();
            if (versionState.overallVersionIs != VersionState.VersionIs.LESS) {
                this.installType.setText(this.parseText(this.getString("summary.already.up.to.date")));
                this.parent.lockNextButton();
                this.add((Component)this.installType, "nextLine");
                return;
            }
            this.installType.setText(this.parseText(this.getString("summary.upgrade.installation")));
        } else {
            this.installType.setText(this.parseText(this.getString("summary.new.install")));
        }
        this.add((Component)this.installType, "nextLine");
        this.installLocation = new JLabel(this.parseText(this.getString("summary.install.location")));
        this.installLocation.setBorder(this.paddingBorder);
        this.add((Component)this.installLocation, "nextLine");
        if (this.rules.isConditionTrue("install.node") || this.rules.isConditionTrue("install.code") || this.rules.isConditionTrue("install.git")) {
            this.topSeparatorStrut = IzPanelLayout.createVerticalStrut(10);
            this.add(this.topSeparatorStrut);
        }
        if (this.rules.isConditionTrue("install.code")) {
            this.codeInstallation = new JLabel(this.parseText(this.getString("summary.code.install")));
            this.codeInstallation.setBorder(this.paddingBorder);
            this.add((Component)this.codeInstallation, "nextLine");
        }
        if (this.rules.isConditionTrue("install.git")) {
            this.gitInstallation = new JLabel(this.parseText(this.getString("summary.git.install")));
            this.gitInstallation.setBorder(this.paddingBorder);
            this.add((Component)this.gitInstallation, "nextLine");
        }
        this.add(this.bottomSeparatorStrut);
        this.nextToInstallMessage = new JLabel(this.parseText(this.getString("summary.next.message")));
        this.nextToInstallMessage.setBorder(this.paddingBorder);
        this.add((Component)this.nextToInstallMessage, "nextLine");
    }

    @Override
    public void panelDeactivate() {
        super.panelDeactivate();
        this.parent.getNavigator().setNextText(this.getString("installer.next"));
    }
}

