/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.data;

import com.izforge.izpack.api.config.Config;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.data.VariableMapper;
import com.izforge.izpack.api.exception.IzPackException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

public class DefaultOverrides
extends Options
implements Overrides {
    public DefaultOverrides(File file) throws IOException {
        Config config = Config.getGlobal().clone();
        config.setFileEncoding(Charset.forName("UTF-8"));
        config.setInclude(true);
        config.setComment(true);
        this.setConfig(config);
        this.setFile(file);
    }

    @Override
    public String fetch(String name) {
        return this.processMapping(name, super.fetch(name));
    }

    @Override
    public String fetch(String name, String defaultValue) {
        return this.processMapping(name, super.fetch((Object)name, defaultValue));
    }

    @Override
    public boolean containsKey(String name) {
        return super.containsKey(name);
    }

    @Override
    public String remove(String name) {
        return (String)super.remove(name);
    }

    @Override
    public void setInstallData(InstallData installData) {
        this.getConfig().setInstallData(installData);
    }

    private String processMapping(String name, String value) {
        List<String> comments;
        boolean isMappingMode = false;
        if (value != null && (comments = this.getComment(name)) != null) {
            for (String comment : comments) {
                String[] entries;
                if (comment == null) continue;
                comment = comment.trim();
                for (String entry : entries = comment.split("(\\r?\\n)|;|,")) {
                    if ((entry = entry.trim()).isEmpty()) continue;
                    if (entry.equals("BEGIN MAP")) {
                        isMappingMode = true;
                        continue;
                    }
                    if (entry.equals("END MAP")) {
                        isMappingMode = false;
                        continue;
                    }
                    if (!isMappingMode) continue;
                    Class<?> mapperClass = null;
                    VariableMapper instance = null;
                    try {
                        mapperClass = Class.forName(entry);
                        instance = (VariableMapper)mapperClass.newInstance();
                        value = instance.map(value);
                    }
                    catch (Exception e) {
                        throw new IzPackException("Failure mapping override of variable '" + name + "' defined in file " + this.getFile(), e);
                    }
                }
            }
        }
        return value;
    }
}

