/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.atpinstall;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.sage.izpack.panels.atpinstall.AbstractUIProcessHandler;
import com.sage.izpack.panels.atpinstall.ButtonConfig;
import com.sage.izpack.panels.atpinstall.ErrorHandlingStrategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class ProcessPanelWorker
implements Runnable {
    public static final String SPEC_RESOURCE_NAME = "ProcessPanel.Spec.xml";
    private AbstractUIProcessHandler handler;
    private ArrayList<ProcessingJob> jobs = new ArrayList();
    private ArrayList<ProcessingJob> catchJobs = new ArrayList();
    private ArrayList<ProcessingJob> finalJobs = new ArrayList();
    private boolean result = true;
    private PrintWriter logfile = null;
    private String logfiledir = null;
    private final InstallData idata;
    private final Map<Boolean, List<ButtonConfig>> buttonConfigs = new HashMap<Boolean, List<ButtonConfig>>();
    private final RulesEngine rules;
    private final Resources resources;
    private final PlatformModelMatcher matcher;
    private static final Logger logger = Logger.getLogger(ProcessPanelWorker.class.getName());

    public ProcessPanelWorker(InstallData installData, RulesEngine rulesEngine, Resources resources, PlatformModelMatcher platformModelMatcher) {
        this.idata = installData;
        this.rules = rulesEngine;
        this.resources = resources;
        this.matcher = platformModelMatcher;
    }

    public void setHandler(AbstractUIProcessHandler abstractUIProcessHandler) {
        this.handler = abstractUIProcessHandler;
    }

    private boolean readSpec() throws IOException {
        ArrayList<Processable> arrayList = new ArrayList<Processable>();
        ErrorHandlingStrategy errorHandlingStrategy = ErrorHandlingStrategy.FAIL;
        String string = "$INSTALL_PATH";
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string2 = "";
        String string3 = "";
        Condition condition = this.rules.getCondition("test.mode");
        Condition condition2 = this.rules.getCondition("is.upgrade");
        string2 = "Install Sage X3 Automated Test Platform";
        string3 = "powershell.exe";
        arrayList3.add("\"$TEMP_DIRECTORY/scripts/installATP.ps1\"");
        arrayList3.add("-ATPVersion '$APP_VER'");
        arrayList3.add("-Path '$INSTALL_PATH'");
        if (condition2 != null && condition2.isTrue()) {
            arrayList3.add("-Upgrade");
        }
        if (condition != null && condition.isTrue()) {
            arrayList3.add("-IsTest");
        }
        arrayList.add(new ExecutableFile(string3, arrayList3, arrayList2, string, errorHandlingStrategy));
        this.jobs.add(new ProcessingJob(string2, arrayList));
        errorHandlingStrategy = ErrorHandlingStrategy.IGNORE;
        arrayList = new ArrayList();
        arrayList3 = new ArrayList();
        string2 = "Reset Powershell Execution Policy";
        string3 = "powershell.exe";
        arrayList3.add("java");
        arrayList3.add("-jar \"$TEMP_DIRECTORY\\scripts\\atp.ps.restrictions.jar\"");
        arrayList3.add("${preinstall.policy}");
        arrayList.add(new ExecutableFile(string3, arrayList3, arrayList2, string, errorHandlingStrategy));
        this.jobs.add(new ProcessingJob(string2, arrayList));
        this.buttonConfigs.put(Boolean.FALSE, new ArrayList());
        this.buttonConfigs.put(Boolean.TRUE, new ArrayList());
        this.buttonConfigs.get(Boolean.FALSE).add(new ButtonConfig(null, true, false));
        this.buttonConfigs.get(Boolean.TRUE).add(new ButtonConfig(null, false, true));
        return true;
    }

    @Override
    public void run() {
        boolean bl;
        try {
            this.jobs.clear();
            if (!this.readSpec()) {
                System.err.println("Error parsing XML specification for processing.");
                return;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return;
        }
        if (this.logfiledir != null) {
            this.logfiledir = IoHelper.translatePath(this.logfiledir, this.idata.getVariables());
            Object object = this.idata.getVariable("APP_VER");
            object = object != null ? "V" + object : "undef";
            String bl2 = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            bl2 = ((String)object).replace(' ', '_') + "_" + bl2;
            try {
                File file = File.createTempFile("Install_" + bl2 + "_", ".log", new File(this.logfiledir));
                this.logfile = new PrintWriter(new FileOutputStream(file), true);
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        this.handler.startProcessing(this.jobs.size());
        for (ProcessingJob processingJob : this.jobs) {
            this.result = this.runJob(processingJob);
            if (this.result) continue;
            for (ProcessingJob processingJob2 : this.catchJobs) {
                this.runJob(processingJob2);
            }
        }
        for (ProcessingJob processingJob : this.finalJobs) {
            this.runJob(processingJob);
        }
        boolean bl2 = true;
        boolean bl3 = false;
        for (ButtonConfig buttonConfig : this.buttonConfigs.get(this.result)) {
            String string = buttonConfig.getConditionid();
            if (string != null && string.length() > 0) {
                logger.fine("Condition for job: " + string);
                Condition condition = this.rules.getCondition(string);
                if (condition != null && !condition.isTrue()) {
                    logger.fine("Condition " + string + " is not fulfilled");
                    continue;
                }
            }
            bl2 = buttonConfig.isUnlockNext();
            bl = buttonConfig.isUnlockPrev();
            break;
        }
        this.handler.finishProcessing(bl, bl2);
        if (this.logfile != null) {
            this.logfile.close();
        }
    }

    private boolean runJob(ProcessingJob processingJob) {
        this.handler.startProcess(processingJob.name);
        Boolean bl = processingJob.run(this.handler, this.idata.getVariables());
        this.handler.finishProcess();
        return bl;
    }

    public void startThread() {
        Thread thread = new Thread((Runnable)this, "processing thread");
        thread.start();
    }

    public boolean getResult() {
        return this.result;
    }

    private boolean jobRequiredFor(List<IXMLElement> list) {
        if (list.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.getSelectedPacks().size(); ++i) {
            String string = this.idata.getSelectedPacks().get(i).getName();
            for (IXMLElement iXMLElement : list) {
                String string2 = iXMLElement.getAttribute("name", "");
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private class ExecutableFile
    implements Processable {
        private String filename;
        private String workingDir;
        private final ErrorHandlingStrategy errorHandlingStrategy;
        private List<String> arguments;
        private List<String> envvariables;
        protected AbstractUIProcessHandler handler;

        public ExecutableFile(String string, List<String> list, List<String> list2, String string2, ErrorHandlingStrategy errorHandlingStrategy) {
            this.filename = string;
            this.arguments = list;
            this.envvariables = list2;
            this.workingDir = string2;
            this.errorHandlingStrategy = errorHandlingStrategy;
        }

        @Override
        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, Variables variables) {
            Object object;
            Object object3;
            this.handler = abstractUIProcessHandler;
            ArrayList<String> arrayList = new ArrayList<String>(this.arguments.size() + 1);
            try {
                object3 = variables.replace(this.filename);
                if (!(!System.getProperty("os.name").contains("Windows") || ((String)object3).startsWith("\"") && ((String)object3).endsWith("\""))) {
                    arrayList.add("\"" + (String)object3 + "\"");
                } else {
                    arrayList.add((String)object3);
                }
            }
            catch (Exception exception) {
                arrayList.add(this.filename);
            }
            for (String object22 : this.arguments) {
                try {
                    arrayList.add(variables.replace(object22));
                }
                catch (Exception process) {
                    arrayList.add(object22);
                }
            }
            object3 = new ProcessBuilder(arrayList);
            if (this.workingDir != null && !this.workingDir.equals("")) {
                this.workingDir = IoHelper.translatePath(this.workingDir, variables);
                ((ProcessBuilder)object3).directory(new File(this.workingDir));
            }
            Map<String, String> map = ((ProcessBuilder)object3).environment();
            for (String string : this.envvariables) {
                object = variables.replace(string);
                int n = ((String)object).indexOf("=");
                if (n <= 0) continue;
                map.put(((String)object).substring(0, n), ((String)object).substring(n + 1));
            }
            try {
                Process iOException = ((ProcessBuilder)object3).start();
                OutputMonitor outputMonitor = new OutputMonitor(this.handler, iOException.getInputStream(), false);
                object = new OutputMonitor(this.handler, iOException.getErrorStream(), true);
                Thread thread = new Thread(outputMonitor);
                Thread thread2 = new Thread((Runnable)object);
                thread.setDaemon(true);
                thread2.setDaemon(true);
                thread.start();
                thread2.start();
                try {
                    int interruptedException = iOException.waitFor();
                    this.stopMonitor(outputMonitor, thread);
                    this.stopMonitor((OutputMonitor)object, thread2);
                    if (interruptedException != 0) {
                        if (this.errorHandlingStrategy == ErrorHandlingStrategy.ASK) {
                            QuestionErrorDisplayer questionErrorDisplayer = new QuestionErrorDisplayer(abstractUIProcessHandler);
                            SwingUtilities.invokeAndWait(questionErrorDisplayer);
                            return questionErrorDisplayer.shouldContinue();
                        }
                        if (this.errorHandlingStrategy == ErrorHandlingStrategy.IGNORE) {
                            return true;
                        }
                        this.handler.emitError("Process failed", "An error occurred while executing " + this.filename);
                        return false;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    iOException.destroy();
                    this.handler.emitError("process interrupted", invocationTargetException.toString());
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    iOException.destroy();
                    this.handler.emitError("process interrupted", interruptedException.toString());
                    return false;
                }
            }
            catch (IOException iOException) {
                this.handler.emitError("I/O error", iOException.toString());
                return false;
            }
            return true;
        }

        private void stopMonitor(OutputMonitor outputMonitor, Thread thread) {
            outputMonitor.doStop();
            long l = 500L;
            try {
                thread.join(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!thread.isAlive()) {
                return;
            }
            thread.interrupt();
            long l2 = 500L;
            try {
                thread.join(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public class OutputMonitor
        implements Runnable {
            private boolean stderr = false;
            private AbstractUIProcessHandler handler;
            private BufferedReader reader;
            private Boolean stop = false;

            public OutputMonitor(AbstractUIProcessHandler abstractUIProcessHandler, InputStream inputStream, boolean bl) {
                this.stderr = bl;
                this.reader = new BufferedReader(new InputStreamReader(inputStream));
                this.handler = abstractUIProcessHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    String string;
                    while ((string = this.reader.readLine()) != null) {
                        if (!(string.toLowerCase().contains("npm warn") || string.contains("vulnerabilities") || string.contains("npm fund") || string.contains("npm audit fix") || string.contains("looking for funding"))) {
                            this.handler.logOutput(string, this.stderr);
                        }
                        if (ProcessPanelWorker.this.logfile != null) {
                            ProcessPanelWorker.this.logfile.println(string);
                        }
                        Boolean bl = this.stop;
                        synchronized (bl) {
                            if (this.stop.booleanValue()) {
                                return;
                            }
                        }
                    }
                    return;
                }
                catch (IOException iOException) {
                    this.handler.logOutput(iOException.toString(), true);
                    if (ProcessPanelWorker.this.logfile == null) return;
                    ProcessPanelWorker.this.logfile.println(iOException.toString());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doStop() {
                Boolean bl = this.stop;
                synchronized (bl) {
                    this.stop = true;
                }
            }
        }
    }

    private static class ProcessingJob
    implements Processable {
        public String name;
        private List<Processable> processables;

        public ProcessingJob(String string, List<Processable> list) {
            this.name = string;
            this.processables = list;
        }

        @Override
        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, Variables variables) {
            for (Processable processable : this.processables) {
                if (processable.run(abstractUIProcessHandler, variables)) continue;
                return false;
            }
            return true;
        }
    }

    private static class QuestionErrorDisplayer
    implements Runnable {
        private AbstractUIProcessHandler uiHandler;
        private boolean toBeContinued = true;

        QuestionErrorDisplayer(AbstractUIProcessHandler abstractUIProcessHandler) {
            this.uiHandler = abstractUIProcessHandler;
        }

        @Override
        public void run() {
            if (this.uiHandler.askQuestion("Process execution failed", "Continue anyway?", 37, 47) == 49) {
                this.mustContinue(false);
            }
        }

        public synchronized boolean shouldContinue() {
            return this.toBeContinued;
        }

        public synchronized void mustContinue(boolean bl) {
            this.toBeContinued = bl;
        }
    }

    private static class ExecutableClass
    implements Processable {
        private final String myClassName;
        private final List<String> myArguments;
        protected AbstractUIProcessHandler myHandler;

        public ExecutableClass(String string, List<String> list) {
            this.myClassName = string;
            this.myArguments = list;
        }

        @Override
        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, Variables variables) {
            boolean bl;
            block19: {
                bl = false;
                this.myHandler = abstractUIProcessHandler;
                String[] stringArray = new String[this.myArguments.size()];
                int n = 0;
                for (String object : this.myArguments) {
                    stringArray[n] = variables.replace(object);
                    ++n;
                }
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class<?> clazz = classLoader.loadClass(this.myClassName);
                    Object obj = clazz.newInstance();
                    Method method = clazz.getMethod("run", AbstractUIProcessHandler.class, String[].class);
                    if (method.getReturnType().getName().equals("boolean")) {
                        bl = (Boolean)method.invoke(obj, this.myHandler, stringArray);
                    } else {
                        method.invoke(obj, this.myHandler, stringArray);
                        bl = true;
                    }
                }
                catch (SecurityException securityException) {
                    this.myHandler.emitError("Post Processing Error", "Security exception thrown when processing class: " + this.myClassName);
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Security exception thrown when processing class: " + this.myClassName, securityException);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.myHandler.emitError("Post Processing Error", "Cannot find processing class: " + this.myClassName);
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Cannot find processing class: " + this.myClassName, classNotFoundException);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.myHandler.emitError("Post Processing Error", "Processing class does not have 'run' method: " + this.myClassName);
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Processing class does not have 'run' method: " + this.myClassName, noSuchMethodException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.myHandler.emitError("Post Processing Error", "Error accessing processing class: " + this.myClassName);
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Error accessing processing class: " + this.myClassName, illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.myHandler.emitError("Post Processing Error", "Invocation Problem calling: " + this.myClassName + ", " + invocationTargetException.getCause().getMessage());
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Invocation Problem calling: " + this.myClassName, invocationTargetException);
                    }
                }
                catch (Exception exception) {
                    this.myHandler.emitError("Post Processing Error", "Exception when running processing class: " + this.myClassName + ", " + exception.getMessage());
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Exception when running processing class: " + this.myClassName, exception);
                    }
                }
                catch (Error error) {
                    this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + error.getMessage());
                    if (Debug.isSTACKTRACE()) {
                        logger.log(Level.SEVERE, "Error when running processing class: " + this.myClassName, error);
                    }
                }
                catch (Throwable throwable) {
                    this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + throwable.getMessage());
                    if (!Debug.isSTACKTRACE()) break block19;
                    logger.log(Level.SEVERE, "Error when running processing class: " + this.myClassName, throwable);
                }
            }
            return bl;
        }
    }

    static interface Processable {
        public boolean run(AbstractUIProcessHandler var1, Variables var2);
    }
}

