/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack.panels.atpinstall;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.sage.izpack.panels.atpinstall.AbstractUIProcessHandler;
import com.sage.izpack.panels.atpinstall.ProcessPanelWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ATPInstall
extends IzPanel
implements AbstractUIProcessHandler {
    private RulesEngine rules;
    private UninstallDataWriter myUninstallDataWriter;
    private Log myLog;
    protected JLabel processLabel;
    protected JProgressBar overallProgressBar;
    private boolean validated = false;
    private JTextArea outputPane;
    private boolean finishedWork = false;
    private ProcessPanelWorker worker;
    private int noOfJobs = 0;
    private int currentJob = 0;

    public ATPInstall(Panel panel, InstallerFrame installerFrame, GUIInstallData gUIInstallData, Resources resources, RulesEngine rulesEngine, PlatformModelMatcher platformModelMatcher) {
        super(panel, installerFrame, gUIInstallData, resources);
        this.rules = rulesEngine;
        this.worker = new ProcessPanelWorker(gUIInstallData, rulesEngine, resources, platformModelMatcher);
        this.worker.setHandler(this);
        JLabel jLabel = new JLabel();
        Font font = jLabel.getFont();
        font = font.deriveFont(1, (float)font.getSize() * 2.0f);
        jLabel.setFont(font);
        jLabel.setHorizontalAlignment(0);
        jLabel.setText(this.getString("ATPInstallPanel.heading"));
        jLabel.setVerticalAlignment(1);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(2);
        borderLayout.setVgap(2);
        this.setLayout(borderLayout);
        this.add((Component)jLabel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.5f);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.processLabel = new JLabel();
        this.processLabel.setAlignmentX(0.5f);
        this.processLabel.setText(" ");
        jPanel.add(this.processLabel);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setAlignmentX(0.5f);
        this.overallProgressBar.setStringPainted(true);
        jPanel.add(this.overallProgressBar);
        this.outputPane = new JTextArea();
        this.outputPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.outputPane);
        jPanel.add(jScrollPane);
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void panelActivate() {
        Dimension dimension = this.parent.getPanelsContainerSize();
        dimension.width -= dimension.width / 4;
        dimension.height = 150;
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.parent.lockNextButton();
        this.currentJob = 0;
        if (!this.finishedWork) {
            this.worker.startThread();
        }
    }

    @Override
    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void logOutput(String string, boolean bl) {
        this.outputPane.append(string + '\n');
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ATPInstall.this.outputPane.setCaretPosition(ATPInstall.this.outputPane.getText().length());
            }
        });
    }

    @Override
    public void startProcessing(final int n) {
        this.noOfJobs = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ATPInstall.this.overallProgressBar.setMaximum(n);
                ATPInstall.this.overallProgressBar.setIndeterminate(true);
                ATPInstall.this.parent.lockPrevButton();
            }
        });
    }

    @Override
    public void startProcess(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ATPInstall.this.processLabel.setText(string);
                ATPInstall.this.currentJob++;
                ATPInstall.this.overallProgressBar.setValue(ATPInstall.this.currentJob);
                ATPInstall.this.overallProgressBar.setString(String.valueOf(ATPInstall.this.currentJob) + " / " + String.valueOf(ATPInstall.this.noOfJobs));
            }
        });
    }

    @Override
    public void finishProcess() {
    }

    @Override
    public void finishProcessing(final boolean bl, final boolean bl2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ATPInstall.this.overallProgressBar.setIndeterminate(false);
                String string = Integer.toString(ATPInstall.this.noOfJobs);
                ATPInstall.this.overallProgressBar.setString(string + " / " + string);
                ATPInstall.this.processLabel.setText(" ");
                ATPInstall.this.processLabel.setEnabled(false);
                ATPInstall.this.validated = true;
                ATPInstall.this.installData.setInstallSuccess(ATPInstall.this.worker.getResult());
                if (ATPInstall.this.installData.getPanels().indexOf(ATPInstall.this) != ATPInstall.this.installData.getPanels().size() - 1 && bl2) {
                    ATPInstall.this.parent.unlockNextButton();
                }
                if (bl) {
                    ATPInstall.this.parent.unlockPrevButton();
                }
                ATPInstall.this.finishedWork = ATPInstall.this.installData.isInstallSuccess();
            }
        });
    }
}

