/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.panels.target.TargetPanelAutomation;
import com.sage.izpack.InstallationInformationHelper;
import com.sage.izpack.ModifyInstallationUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetNewPanelAutomationHelper
extends TargetPanelAutomation {
    private static Logger logger = Logger.getLogger(TargetNewPanelAutomationHelper.class.getName());
    private static final String logPrefix = "TargetNewPanelAutomationHelper - ";

    @Override
    public void runAutomated(InstallData installData, IXMLElement panelRoot) {
        IXMLElement ipath = panelRoot.getFirstChildNamed("installpath");
        String path = ipath.getContent();
        logger.log(Level.FINE, "TargetNewPanelAutomationHelper - runAutomated  path: " + path);
        this.handleInstallPath(installData, path);
    }

    @Override
    public void processOptions(InstallData installData, Overrides overrides) {
        String path = overrides.fetch("INSTALL_PATH");
        logger.log(Level.FINE, "TargetNewPanelAutomationHelper - processOptions  path: " + path);
        if (path != null) {
            this.handleInstallPath(installData, path);
        }
    }

    private void handleInstallPath(InstallData installData, String path) {
        logger.log(Level.FINE, "TargetNewPanelAutomationHelper - handleInstallPath  path: " + path);
        path = installData.getVariables().replace(path);
        boolean modifyinstallation = ModifyInstallationUtil.get(installData);
        logger.log(Level.FINE, "TargetNewPanelAutomationHelper - handleInstallPath   modifyinstallation: " + modifyinstallation + " path: " + path);
        if (modifyinstallation && InstallationInformationHelper.isIncompatibleInstallation(path, InstallationInformationHelper.isReadInformation(installData))) {
            throw new InstallerException(installData.getMessages().get("TargetPanel.incompatibleInstallation", new Object[0]));
        }
        installData.setInstallPath(path);
    }
}

