/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ReadMeNewPanel
extends IzPanel
implements HyperlinkListener,
ActionListener {
    private static final Logger logger = Logger.getLogger(ReadMeNewPanel.class.getName());
    private static final long serialVersionUID = 3256745385458746416L;
    private JCheckBox readCheckBox;
    private JEditorPane textArea;

    public ReadMeNewPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, new IzPanelLayout(log), resources);
        this.loadReadMe();
        this.add(LabelFactory.create(super.getString("ReadMeNewPanel.info"), 10));
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadReadMe());
            this.add((Component)scroller, "nextLine");
            ButtonGroup group = new ButtonGroup();
            this.readCheckBox = new JCheckBox();
            String agree = this.getString("ReadMeNewPanel.agree");
            this.readCheckBox.setText(agree);
            group.add(this.readCheckBox);
            this.add((Component)this.readCheckBox, "nextLine");
            this.readCheckBox.addActionListener(this);
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "ReadMeNewPanel :" + err.getMessage());
            err.printStackTrace();
        }
        this.setInitialFocus(this.textArea);
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.readCheckBox.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (Exception err) {
                    this.textArea.setPage(e.getURL());
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @Override
    public boolean isValidated() {
        if (!this.readCheckBox.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.readCheckBox.isSelected();
    }

    private URL loadReadMe() {
        String resNamePrifix = "ReadMeNewPanel.readme";
        try {
            logger.log(Level.FINE, "ReadMeNewPanel loadReadme: " + resNamePrifix);
            URL url = this.getResources().getURL(resNamePrifix);
            String debug = "NULL";
            if (url != null) {
                debug = url.getPath();
            }
            logger.log(Level.FINE, "ReadMeNewPanel loadReadme return " + debug);
            return url;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void panelActivate() {
        if (!this.readCheckBox.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

