/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.panels.checkedhello.CheckedHelloPanelAutomationHelper;
import com.izforge.izpack.panels.checkedhello.RegistryHelper;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.CheckedHelloNewPanel;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.RegistryHandlerX3;
import com.sage.izpack.ResourcesHelper;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckedHelloNewPanelAutomationHelper
extends CheckedHelloPanelAutomationHelper {
    private static final Logger logger = Logger.getLogger(CheckedHelloNewPanelAutomationHelper.class.getName());
    private final RegistryHelper registryHelper;
    private final InstallData installData;
    private final RegistryHandler registryHandler;
    private final RegistryHandlerX3 x3Handler;
    private static final String logPrefix = "CheckedHelloNewPanelAutomationHelper - ";

    public CheckedHelloNewPanelAutomationHelper(RegistryDefaultHandler handler, InstallData installData, Resources resources) throws NativeLibException {
        super(handler, installData);
        logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - Constructor");
        this.registryHelper = new RegistryHelper(handler, installData);
        this.registryHandler = handler != null ? handler.getInstance() : null;
        this.installData = installData;
        this.x3Handler = new RegistryHandlerX3(this.registryHandler, installData);
        CheckedHelloNewPanel.initPath(installData, resources, this.registryHelper, this.x3Handler);
    }

    @Override
    public void runAutomated(InstallData installData, IXMLElement panelRoot) {
        String allowMultipleInstall;
        String string = allowMultipleInstall = installData != null ? installData.getVariable("allow-multiple-instance") : "";
        if (Boolean.TRUE.toString().equalsIgnoreCase(allowMultipleInstall)) {
            logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - runAutomated - allowMultipleInstall:" + allowMultipleInstall);
        } else {
            logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - runAutomated");
        }
        ModifyInstallationUtil.set(installData, this.isUpdate(installData));
        RegistryHandlerX3 x3Handler = new RegistryHandlerX3(this.registryHandler, installData);
        if (x3Handler.needAdxAdmin()) {
            try {
                String adxAdminPath = x3Handler.getAdxAdminDirPath();
                boolean adxAdminInstalled = adxAdminPath != null;
                logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - runAutomated - adxAdminInstalled: " + adxAdminInstalled);
                if (!adxAdminInstalled) {
                    logger.log(Level.FINE, ResourcesHelper.getCustomPropString("adxadminNotRegistered"));
                    System.out.println(ResourcesHelper.getCustomPropString("adxadminNotRegistered"));
                    System.out.println();
                    return;
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - runAutomated - Error: " + e.getMessage());
                logger.log(Level.WARNING, ResourcesHelper.getCustomPropString("installer.error") + ":" + e.getMessage());
                return;
            }
        }
        Variables variables = this.installData.getVariables();
        installData.setVariable("UNINSTALL_NAME", variables.get("APP_NAME"));
    }

    public static void setUniqueUninstallKey(RegistryHandler registryHandler, RegistryHelper registryHelper, ResourcesHelper resourcesHelper) throws Exception {
        int oldVal = registryHandler.getRoot();
        if (oldVal > 100) {
            return;
        }
        String uninstallName = registryHelper.getUninstallName();
        int uninstallModifier = 1;
        while (true) {
            if (uninstallName == null) {
                logger.log(Level.WARNING, "CheckedHelloNewPanelAutomationHelper - setUniqueUninstallKey - uninstallName returns NULL");
                break;
            }
            String newUninstallName = uninstallName + "(" + Integer.toString(uninstallModifier) + ")";
            String keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + newUninstallName;
            registryHandler.setRoot(-2147483646);
            if (!registryHandler.keyExist(keyName)) {
                registryHandler.setUninstallName(newUninstallName);
                logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - setUniqueUninstallKey() " + CheckedHelloNewPanelAutomationHelper.getString("CheckedHelloNewPanel.infoOverUninstallKey", resourcesHelper) + newUninstallName);
                break;
            }
            ++uninstallModifier;
        }
    }

    public static String getString(String key, ResourcesHelper resourcesHelper) {
        return resourcesHelper.getCustomString(key);
    }

    private boolean isUpdate(InstallData installData) {
        if (OsVersion.IS_WINDOWS) {
            try {
                boolean isRegistered = this.registryHelper.isRegistered();
                logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - isUpdate - isRegistered:" + isRegistered);
                return isRegistered;
            }
            catch (NativeLibException e) {
                logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - isUpdate - error:" + e.getMessage());
                return Boolean.FALSE;
            }
        }
        if (installData == null || installData.getInfo() == null || installData.getInfo().getUninstallerPath() == null || installData.getInstallPath() == null) {
            logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - isUpdate - installData=null or installData.getInstallPath()==null return false");
            return Boolean.FALSE;
        }
        String uninstallerPath = installData.getInfo().getUninstallerPath().replaceAll("\\$INSTALL_PATH", installData.getInstallPath()) + File.separator + "uninstaller.jar";
        logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - isUpdate - checking for presence of uninstaller, path=" + uninstallerPath);
        File uninstaller = new File(uninstallerPath);
        boolean exists = uninstaller.exists();
        logger.log(Level.FINE, "CheckedHelloNewPanelAutomationHelper - isUpdate - uninstaller.jar exists: " + (exists ? "yes" : "no"));
        return exists;
    }
}

