/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.OsVersion;
import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckXtremServiceConfiguration
implements DataValidator {
    private static final String errLogon = "errwinsrvaccount";
    private static final String errLogonService = "warnwinsrvaccount";
    private static final String warnLogonServiceChanged = "warnLogonServiceChanged";
    private String errorMsg = "errwinsrvaccount";
    private static final Logger logger = Logger.getLogger(CheckXtremServiceConfiguration.class.getName());
    private static final String prefixLabel = "CheckXtremCertificateValidator - ";

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMsg;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorMsg;
    }

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        logger.log(Level.FINE, "CheckXtremCertificateValidator - validateData.");
        if (!OsVersion.IS_WINDOWS) {
            return DataValidator.Status.OK;
        }
        DataValidator.Status bReturn = DataValidator.Status.ERROR;
        try {
            String userName = installData.getVariable("winservice.username");
            String passWord = installData.getVariable("winservice.password");
            String strDomain = ".";
            String bUseDomain = "true";
            if (userName.contains("\\")) {
                strDomain = userName.substring(0, userName.indexOf("\\"));
                userName = userName.substring(userName.indexOf("\\") + 1);
            } else if (userName.contains("@")) {
                strDomain = null;
            } else {
                bUseDomain = "false";
            }
            WinNT.HANDLEByReference phToken = new WinNT.HANDLEByReference();
            if (!Advapi32.INSTANCE.LogonUser(userName, strDomain, passWord, 3, 0, phToken)) {
                throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
            }
            Kernel32.INSTANCE.CloseHandle(phToken.getValue());
            if (!Advapi32.INSTANCE.LogonUser(userName, strDomain, passWord, 5, 0, phToken)) {
                bReturn = DataValidator.Status.ERROR;
                this.errorMsg = errLogonService;
                return bReturn;
            }
            bReturn = DataValidator.Status.OK;
            Kernel32.INSTANCE.CloseHandle(phToken.getValue());
            installData.setVariable("winservice.usedomain", bUseDomain);
            if (strDomain != null && ".".equals(strDomain)) {
                installData.setVariable("winservice.username", userName);
            }
            String encodedString = Base64.getEncoder().encodeToString(passWord.getBytes());
            installData.setVariable("winservice.passwordbase64", "base64:" + encodedString);
            bReturn = DataValidator.Status.OK;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage());
            bReturn = DataValidator.Status.ERROR;
        }
        logger.log(Level.FINE, "CheckXtremCertificateValidator - validateData returns: " + (Object)((Object)bReturn));
        return bReturn;
    }
}

