/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.MoreAdvApi32;
import com.sage.izpack.StringUtil;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckSyracusePassphraseValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckSyracusePassphraseValidator.class.getName());
    private static final String logPrefix = "CheckSyracusePassphraseValidator - ";
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";
    public static final int STILL_ACTIVE = 259;

    @Override
    public DataValidator.Status validateData(InstallData installdata) {
        DataValidator.Status sreturn = DataValidator.Status.OK;
        boolean updateMode = ModifyInstallationUtil.get(installdata);
        boolean createCertificate = true;
        if (installdata.getVariable("syracuse.certificate.install") != null) {
            createCertificate = installdata.getVariable("syracuse.certificate.install").equalsIgnoreCase("true");
        }
        logger.log(Level.FINE, "CheckSyracusePassphraseValidator - createCertificate: " + createCertificate);
        if (!updateMode) {
            sreturn = OsVersion.IS_WINDOWS ? this.updatePassphraseWindows(installdata) : this.updatePassphraseLinux(installdata);
        }
        return sreturn;
    }

    private DataValidator.Status updatePassphraseLinux(InstallData installData) {
        logger.log(Level.FINE, "CheckSyracusePassphraseValidator - Begin updatePassphraseLinux: ");
        DataValidator.Status sreturn = DataValidator.Status.OK;
        String userName = installData.getVariable("syracuse.winservice.username");
        String passphrasePath = installData.getVariable("INSTALL_PATH") + File.separator + "syracuse";
        String certsDir = installData.getVariable("syracuse.dir.certs");
        boolean certCreate = Boolean.parseBoolean(installData.getVariable("syracuse.certificate.install"));
        String strHOST_NAME = installData.getVariable("syracuse.certificate.hostname");
        if (StringUtil.isNullOrBlank(strHOST_NAME)) {
            strHOST_NAME = installData.getVariable("HOST_NAME").toLowerCase();
        }
        String serverPassphrase = installData.getVariable("syracuse.certificate.serverpassphrase");
        logger.log(Level.FINE, "CheckSyracusePassphraseValidator - passphrasePath: " + passphrasePath);
        logger.log(Level.FINE, "CheckSyracusePassphraseValidator - certsDir: " + certsDir);
        logger.log(Level.FINE, "CheckSyracusePassphraseValidator - certCreate: " + certCreate + " strHOST_NAME: " + strHOST_NAME + "  strServerPassphrase: " + serverPassphrase);
        if (!certCreate) {
            serverPassphrase = installData.getVariable("syracuse.ssl.pemkeypassword");
        }
        String passPhraseFile = certsDir + File.separator + strHOST_NAME + File.separator + strHOST_NAME + ".pwd";
        try {
            String line;
            File oldPassphrase = new File(passPhraseFile);
            if (oldPassphrase.exists() && !oldPassphrase.delete()) {
                throw new Exception(passPhraseFile);
            }
            String hexServerPassphrase = StringUtil.asciiToHex(serverPassphrase);
            String scriptPath = "/bin/sh \"" + passphrasePath + File.separator + "passphrasehex.sh\" " + hexServerPassphrase;
            logger.log(Level.FINE, "CheckSyracusePassphraseValidator - scriptPath: " + scriptPath);
            String[] command = new String[]{"/bin/sh", passphrasePath + File.separator + "passphrasehex.sh", hexServerPassphrase};
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logger.log(Level.FINE, "CheckSyracusePassphraseValidator - result:" + line);
                this.strMessage = this.strMessage + line + "\r\n";
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                logger.log(Level.FINE, "CheckSyracusePassphraseValidator - Error detected: exitCode=" + exitCode + ": " + this.strMessage);
                installData.setVariable(strMessageValue, this.strMessage);
                return DataValidator.Status.WARNING;
            }
            logger.log(Level.FINE, "CheckSyracusePassphraseValidator - updatePassphraseLinux exited with code: " + exitCode);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            this.strMessage = "OS error #" + ex.getMessage();
            installData.setVariable(strMessageValue, this.strMessage);
            sreturn = DataValidator.Status.WARNING;
        }
        return sreturn;
    }

    private DataValidator.Status updatePassphraseWindows(InstallData dataInstall) {
        logger.log(Level.FINE, "CheckSyracusePassphraseValidator - Begin updatePassphraseWindows: ");
        DataValidator.Status sreturn = DataValidator.Status.OK;
        String userName = dataInstall.getVariable("syracuse.winservice.username");
        String passWord = dataInstall.getVariable("syracuse.winservice.password");
        String strDomain = ".";
        if (userName.contains("\\")) {
            strDomain = userName.substring(0, userName.indexOf("\\"));
            userName = userName.substring(userName.indexOf("\\") + 1);
        } else if (userName.contains("@")) {
            strDomain = null;
        }
        WString nullW = null;
        WinBase.PROCESS_INFORMATION processInformation = new WinBase.PROCESS_INFORMATION();
        WinBase.STARTUPINFO startupInfo = new WinBase.STARTUPINFO();
        startupInfo.dwFlags = 1;
        startupInfo.wShowWindow = new WinDef.WORD(0L);
        String passphrasePath = dataInstall.getVariable("INSTALL_PATH") + "\\syracuse";
        String certsDir = dataInstall.getVariable("syracuse.dir.certs");
        boolean certCreate = Boolean.parseBoolean(dataInstall.getVariable("syracuse.certificate.install"));
        String strHOST_NAME = dataInstall.getVariable("HOST_NAME").toLowerCase();
        String serverPassphrase = dataInstall.getVariable("syracuse.certificate.serverpassphrase");
        logger.log(Level.FINE, "CheckSyracusePassphraseValidator - passphrasePath: " + passphrasePath);
        logger.log(Level.FINE, "CheckSyracusePassphraseValidator - certsDir: " + certsDir);
        logger.log(Level.FINE, "CheckSyracusePassphraseValidator - certCreate: " + certCreate + " strHOST_NAME: " + strHOST_NAME + "  strServerPassphrase: " + serverPassphrase);
        try {
            String passPhraseFile;
            File oldPassphrase;
            if (!certCreate) {
                serverPassphrase = dataInstall.getVariable("syracuse.ssl.pemkeypassword");
            }
            if ((oldPassphrase = new File(passPhraseFile = certsDir + "\\" + strHOST_NAME + "\\" + strHOST_NAME + ".pwd")).exists() && !oldPassphrase.delete()) {
                throw new Exception(passPhraseFile);
            }
            String hexServerPassphrase = StringUtil.asciiToHex(serverPassphrase);
            logger.log(Level.FINE, "CheckSyracusePassphraseValidator - serverPassphrase : " + serverPassphrase + " hexServerPassphrase: " + hexServerPassphrase);
            File tempFile = new File(passphrasePath + "\\tmpcmd.cmd");
            tempFile.deleteOnExit();
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(tempFile), true);
            printWriter.println("ping -n 5 127.0.0.1>NUL");
            printWriter.println("\"" + passphrasePath + "\\passphrasehex.cmd\" \"" + hexServerPassphrase + "\" 1>out.log 2>err.log");
            printWriter.println("if errorlevel 1 exit /B 1");
            printWriter.close();
            logger.log(Level.FINE, "CheckSyracusePassphraseValidator - tempFile: " + tempFile.getCanonicalPath() + " passphrasehex.cmd " + hexServerPassphrase);
            boolean result2 = MoreAdvApi32.INSTANCE.CreateProcessWithLogonW(new WString(userName), strDomain == null ? nullW : new WString(strDomain), new WString(passWord), 1, nullW, new WString(tempFile.getCanonicalPath()), 1024, null, new WString(passphrasePath), startupInfo, processInformation);
            logger.log(Level.FINE, "CheckSyracusePassphraseValidator - result2: " + result2);
            if (!result2) {
                int error = Kernel32.INSTANCE.GetLastError();
                this.strMessage = "OS error #" + error + " - " + Kernel32Util.formatMessageFromLastErrorCode(error);
                dataInstall.setVariable(strMessageValue, this.strMessage);
                logger.log(Level.FINE, "CheckSyracusePassphraseValidator - error: " + error + " strMessage:" + this.strMessage);
                return DataValidator.Status.WARNING;
            }
            boolean finished = false;
            int loop = 0;
            int exitCode = -2;
            while (!finished) {
                IntByReference lpExitCode = new IntByReference(9999);
                result2 = Kernel32.INSTANCE.GetExitCodeProcess(processInformation.hProcess, lpExitCode);
                if (!result2) {
                    int error = Kernel32.INSTANCE.GetLastError();
                    this.strMessage = "OS error #" + error + " - " + Kernel32Util.formatMessageFromLastErrorCode(error);
                    dataInstall.setVariable(strMessageValue, this.strMessage);
                    logger.log(Level.FINE, "CheckSyracusePassphraseValidator - result2: " + result2 + " strMessage: " + this.strMessage);
                    return DataValidator.Status.WARNING;
                }
                if (lpExitCode.getValue() != 259) {
                    exitCode = lpExitCode.getValue();
                    finished = true;
                    logger.log(Level.FINE, "CheckSyracusePassphraseValidator - finished: " + finished + " loop: " + loop + "s  exitCode: " + exitCode);
                }
                if (++loop > 30) {
                    this.strMessage = "Error # Could not update passphrase ! (" + passPhraseFile + ")";
                    dataInstall.setVariable(strMessageValue, this.strMessage);
                    logger.log(Level.FINE, "CheckSyracusePassphraseValidator - bFinished: " + finished + " loop: " + loop + "s   strMessageValue: " + strMessageValue);
                    return DataValidator.Status.WARNING;
                }
                Thread.sleep(1000L);
            }
            String strErr = new String(Files.readAllBytes(Paths.get(passphrasePath + "\\err.log", new String[0])));
            File strOutFile = new File(passphrasePath + "\\out.log");
            File strErrFile = new File(passphrasePath + "\\err.log");
            strOutFile.delete();
            strErrFile.delete();
            logger.log(Level.FINE, "CheckSyracusePassphraseValidator - updatePassphraseWindows strErr: " + strErr + " " + strOutFile + " deleted");
            if (!finished) {
                logger.log(Level.FINE, "CheckSyracusePassphraseValidator - Error detected updatePassphraseWindows: exitCode=" + exitCode + ":" + strErr);
                return DataValidator.Status.WARNING;
            }
            if (finished && exitCode != 0) {
                logger.log(Level.FINE, "CheckSyracusePassphraseValidator - Error detected updatePassphraseWindows: exitCode=" + exitCode + ": " + this.strMessage);
                logger.log(Level.FINE, "CheckSyracusePassphraseValidator - Error detected updatePassphraseWindows: exitCode=" + exitCode + ":" + strErr);
                dataInstall.setVariable(strMessageValue, this.strMessage);
                return DataValidator.Status.WARNING;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            this.strMessage = "OS error #" + ex.getMessage();
            dataInstall.setVariable(strMessageValue, this.strMessage);
            sreturn = DataValidator.Status.WARNING;
        }
        return sreturn;
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

