/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sage.izpack.CertificateGeneratorHelper;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class CheckSyracuseCertManagerDataValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckSyracuseCertManagerDataValidator.class.getName());
    private static final String logPrefix = "CheckSyracuseCertManagerDataValidator - ";
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";
    private KeyPair pairCA = null;
    private X509Certificate cacert = null;

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        Boolean modifyInstallation = ModifyInstallationUtil.get(installData);
        boolean mongoSSL = Boolean.parseBoolean(installData.getVariable("mongodb.ssl.enable"));
        try {
            if (!modifyInstallation.booleanValue()) {
                String localHOST_NAME = installData.getVariable("HOST_NAME").toLowerCase();
                String strCertPath = installData.getVariable("syracuse.dir.certs") + File.separator + localHOST_NAME;
                String hostname = "";
                boolean certCreate = Boolean.parseBoolean(installData.getVariable("syracuse.certificate.install"));
                if (certCreate) {
                    this.certCreate(installData);
                    hostname = installData.getVariable("syracuse.certificate.hostname").toLowerCase();
                    installData.setVariable("mongodb.ssl.server.certfile", strCertPath + File.separator + localHOST_NAME + ".crt");
                    installData.setVariable("mongodb.ssl.server.pemkeyfile", strCertPath + File.separator + localHOST_NAME + ".key");
                    installData.setVariable("mongodb.ssl.server.pemcafile", strCertPath + File.separator + "ca.cacrt");
                } else {
                    installData.setVariable("syracuse.certificate.certtool", installData.getVariable("INSTALL_PATH") + File.separator + "syracuse" + File.separator + "certs_tools");
                    this.readCerts(installData);
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    FileInputStream inPemCertFile = new FileInputStream(installData.getVariable("syracuse.ssl.certfile"));
                    X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
                    X500Principal x500Principal = cert.getSubjectX500Principal();
                    String name = x500Principal.getName();
                    String commonName = CertificateGeneratorHelper.extractCommonName(name);
                    hostname = commonName.toLowerCase();
                    installData.setVariable("syracuse.certificate.serverpassphrase", installData.getVariable("syracuse.ssl.pemkeypassword"));
                }
                installData.setVariable("mongodb.ssl.server.serverpassphrase", installData.getVariable("syracuse.certificate.serverpassphrase"));
                String serverPassPhrase = installData.getVariable("syracuse.certificate.serverpassphrase");
                String serverHexPassPhrase = installData.getVariable("syracuse.certificate.hexserverpassphrase");
                if (!StringUtil.isNullOrBlank(serverPassPhrase) && StringUtil.isNullOrBlank(serverHexPassPhrase)) {
                    serverHexPassPhrase = StringUtil.asciiToHex(serverPassPhrase);
                    logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - validateData()  syracuse.certificate.serverpassphrase: " + serverPassPhrase + " - Result set 'syracuse.certificate.hexserverpassphrase': " + serverHexPassPhrase);
                    installData.setVariable("syracuse.certificate.hexserverpassphrase", serverHexPassPhrase);
                }
            }
            if (mongoSSL) {
                if (!modifyInstallation.booleanValue()) {
                    boolean mongodbInstall = Boolean.parseBoolean(installData.getVariable("mongodb.service.install"));
                    boolean certCreate = Boolean.parseBoolean(installData.getVariable("syracuse.certificate.install"));
                    if (certCreate) {
                        if (mongodbInstall) {
                            this.clientCertCreate(installData);
                            installData.setVariable("mongodb.service.hostname", installData.getVariable("syracuse.certificate.hostname").toLowerCase());
                        } else {
                            this.clientPutInPlace(installData, installData.getVariable("mongodb.ssl.pemcafile"));
                        }
                    } else if (mongodbInstall) {
                        this.clientPutInPlace(installData, installData.getVariable("syracuse.ssl.pemcafile"));
                        CertificateFactory factory = CertificateFactory.getInstance("X.509");
                        InputStream inPemCertFile = Files.newInputStream(Paths.get(installData.getVariable("syracuse.ssl.certfile"), new String[0]), new OpenOption[0]);
                        X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
                        X500Principal x500Principal = cert.getSubjectX500Principal();
                        String name = x500Principal.getName();
                        String commonName = CertificateGeneratorHelper.extractCommonName(name);
                        installData.setVariable("mongodb.service.hostname", commonName.toLowerCase());
                    } else {
                        this.clientPutInPlace(installData, installData.getVariable("mongodb.ssl.pemcafile"));
                    }
                } else {
                    this.clientPutInPlace(installData, installData.getVariable("mongodb.ssl.pemcafile"));
                }
            }
            logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - Error in validateData() returning " + (Object)((Object)DataValidator.Status.OK));
            return DataValidator.Status.OK;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - Error in validateData() returning " + (Object)((Object)DataValidator.Status.ERROR) + " - " + ex.getMessage());
            this.strMessage = ex.getMessage();
            installData.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    public void clientPutInPlace(InstallData installData, String fieldPemCaFile) throws Exception {
        logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - clientPutInPlace(" + fieldPemCaFile + ")");
        String fieldPemCertFile = installData.getVariable("mongodb.ssl.client.certfile");
        String fieldPemKeyFile = installData.getVariable("mongodb.ssl.client.pemkeyfile");
        String strCertPath = installData.getVariable("syracuse.dir.certs") + File.separator + "mongodb";
        File dirCerts = new File(strCertPath);
        if (!dirCerts.exists()) {
            dirCerts.mkdirs();
        }
        File certsCaCRT = new File(strCertPath + File.separator + "ca.cacrt");
        File certsServerCRT = new File(strCertPath + File.separator + "client.crt");
        File certsServerKey = new File(strCertPath + File.separator + "client.key");
        File certsServerPem = new File(strCertPath + File.separator + "client.pem");
        if (fieldPemCaFile != null && !fieldPemCaFile.isEmpty() && !fieldPemCaFile.equals(strCertPath + File.separator + "ca.cacrt")) {
            File sourceCaCRT = new File(fieldPemCaFile);
            Files.copy(sourceCaCRT.toPath(), certsCaCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (!fieldPemCertFile.equals(strCertPath + File.separator + "client.crt")) {
            File sourceServerCRT = new File(fieldPemCertFile);
            Files.copy(sourceServerCRT.toPath(), certsServerCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (!fieldPemKeyFile.equals(strCertPath + File.separator + "client.key")) {
            File sourceServerKey = new File(fieldPemKeyFile);
            Files.copy(sourceServerKey.toPath(), certsServerKey.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        CertificateGeneratorHelper.mergeFiles(new File[]{certsServerCRT, certsServerKey}, certsServerPem);
        logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - End clientPutInPlace()");
    }

    public void clientCertCreate(InstallData installData) throws Exception {
        JcaPEMWriter pemWriter;
        logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - clientCertCreate()");
        String countryCode = installData.getVariable("syracuse.certificate.countrycode");
        String state = installData.getVariable("syracuse.certificate.state");
        String city = installData.getVariable("syracuse.certificate.city");
        String organization = installData.getVariable("syracuse.certificate.organization");
        String organizationalUnit = installData.getVariable("syracuse.certificate.organisationalunit");
        String name = installData.getVariable("syracuse.certificate.name");
        String email = installData.getVariable("syracuse.certificate.email");
        int validity = Integer.parseInt(installData.getVariable("syracuse.certificate.validity"));
        KeyPair pairClient = CertificateGeneratorHelper.generateRSAKeyPair(2048);
        X509Certificate clientCert = CertificateGeneratorHelper.generateClientV3Certificate(pairClient, countryCode, organization, organizationalUnit, state, city, name, email, validity, this.cacert, this.pairCA);
        String certDirectory = installData.getVariable("syracuse.dir.certs") + File.separator + "mongodb";
        File dirCerts = new File(certDirectory);
        if (!dirCerts.exists()) {
            dirCerts.mkdirs();
        }
        File certsCaCRT = new File(certDirectory + File.separator + "ca.cacrt");
        File certsServerCRT = new File(certDirectory + File.separator + "client.crt");
        File certsServerKey = new File(certDirectory + File.separator + "client.key");
        File certsServerPem = new File(certDirectory + File.separator + "client.pem");
        try (FileWriter caCertFile = new FileWriter(certsCaCRT);){
            pemWriter = new JcaPEMWriter((Writer)caCertFile);
            try {
                pemWriter.writeObject((Object)this.cacert);
            }
            finally {
                pemWriter.close();
            }
        }
        try (FileWriter clientCertFile = new FileWriter(certsServerCRT);){
            pemWriter = new JcaPEMWriter((Writer)clientCertFile);
            try {
                pemWriter.writeObject((Object)clientCert);
            }
            finally {
                pemWriter.close();
            }
        }
        CertificateGeneratorHelper.writePrivateKey(certDirectory + File.separator + "client.key", pairClient, null);
        CertificateGeneratorHelper.mergeFiles(new File[]{certsServerCRT, certsServerKey}, certsServerPem);
        logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - end clientCertCreate()");
    }

    public void readCerts(InstallData installData) throws Exception {
        boolean setx3webserver;
        File dirCertToolPrivatePath;
        File dirCertToolOutputPath;
        String strCertToolPath;
        File dirCertToolPath;
        logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - readCerts()");
        String fieldPemCertFile = installData.getVariable("syracuse.ssl.certfile");
        String fieldPemKeyFile = installData.getVariable("syracuse.ssl.pemkeyfile");
        String fieldPemKeyPassword = installData.getVariable("syracuse.ssl.pemkeypassword");
        String fieldPemCaFile = installData.getVariable("syracuse.ssl.pemcafile");
        String localHOST_NAME = installData.getVariable("HOST_NAME").toLowerCase();
        String certDirectory = installData.getVariable("syracuse.dir.certs") + File.separator + localHOST_NAME;
        File dirCerts = new File(certDirectory);
        if (!dirCerts.exists()) {
            dirCerts.mkdirs();
        }
        if (!(dirCertToolPath = new File(strCertToolPath = installData.getVariable("syracuse.certificate.certtool"))).exists()) {
            dirCertToolPath.mkdirs();
        }
        if (!(dirCertToolOutputPath = new File(strCertToolPath + File.separator + "output")).exists()) {
            dirCertToolOutputPath.mkdirs();
        }
        if (!(dirCertToolPrivatePath = new File(strCertToolPath + File.separator + "private")).exists()) {
            dirCertToolPrivatePath.mkdirs();
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        InputStream inPemCaFile = Files.newInputStream(Paths.get(fieldPemCaFile, new String[0]), new OpenOption[0]);
        this.cacert = (X509Certificate)factory.generateCertificate(inPemCaFile);
        File sourceCaCRT = new File(fieldPemCaFile);
        File certToolOutputCaCRT = new File(strCertToolPath + File.separator + "output" + File.separator + "ca.cacrt");
        File certsCaCRT = new File(certDirectory + File.separator + "ca.cacrt");
        Files.copy(sourceCaCRT.toPath(), certToolOutputCaCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(sourceCaCRT.toPath(), certsCaCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        InputStream inPemCertFile = Files.newInputStream(Paths.get(fieldPemCertFile, new String[0]), new OpenOption[0]);
        X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
        X500Principal x500Principal = cert.getSubjectX500Principal();
        String name = x500Principal.getName();
        String cn = CertificateGeneratorHelper.extractCommonName(name);
        File sourceServerCRT = new File(fieldPemCertFile);
        File certToolOutputServerCRT = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".crt");
        File certsServerCRT = new File(certDirectory + File.separator + localHOST_NAME + ".crt");
        Files.copy(sourceServerCRT.toPath(), certToolOutputServerCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(sourceServerCRT.toPath(), certsServerCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        File sourceServerKey = new File(fieldPemKeyFile);
        File certToolOutputServerkey = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".key");
        File certsServerkey = new File(certDirectory + File.separator + localHOST_NAME + ".key");
        Files.copy(sourceServerKey.toPath(), certToolOutputServerkey.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(sourceServerKey.toPath(), certsServerkey.toPath(), StandardCopyOption.REPLACE_EXISTING);
        PublicKey pubKey = cert.getPublicKey();
        File certToolOutputServerPub = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".pem");
        FileWriter serverPubFile = new FileWriter(certToolOutputServerPub);
        JcaPEMWriter pem = new JcaPEMWriter((Writer)serverPubFile);
        pem.writeObject((Object)pubKey);
        pem.close();
        boolean setx3runtime = Boolean.parseBoolean(installData.getVariable("syracuse.certificate.setx3runtime"));
        if (setx3runtime) {
            String strX3RuntimePath = installData.getVariable("syracuse.certificate.x3runtime");
            String pemName = localHOST_NAME.replace('@', '_').replace('$', '_').replace('.', '_');
            File x3ServerPub = new File(strX3RuntimePath + File.separator + "keys" + File.separator + pemName + ".pem");
            Files.copy(certToolOutputServerPub.toPath(), x3ServerPub.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (setx3webserver = Boolean.parseBoolean(installData.getVariable("syracuse.certificate.setx3webserver"))) {
            String strX3WebserverPath = installData.getVariable("syracuse.certificate.x3webserverdata");
            String pemName = localHOST_NAME.replace('@', '_').replace('$', '_').replace('.', '_');
            File x3ServerPub = new File(strX3WebserverPath + File.separator + pemName + ".pem");
            Files.copy(certToolOutputServerPub.toPath(), x3ServerPub.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - end readCerts()");
    }

    public void certCreate(InstallData installData) throws Exception {
        boolean setx3webserver;
        File dirCertToolPrivatePath;
        File dirCertToolOutputPath;
        String strCertToolPath;
        File dirCertToolPath;
        logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - certCreate()");
        String countryCode = installData.getVariable("syracuse.certificate.countrycode");
        String state = installData.getVariable("syracuse.certificate.state");
        String city = installData.getVariable("syracuse.certificate.city");
        String organization = installData.getVariable("syracuse.certificate.organization");
        String organizationalUnit = installData.getVariable("syracuse.certificate.organisationalunit");
        String name = installData.getVariable("syracuse.certificate.name");
        String email = installData.getVariable("syracuse.certificate.email");
        int validity = Integer.parseInt(installData.getVariable("syracuse.certificate.validity"));
        String localHOST_NAME = installData.getVariable("HOST_NAME").toLowerCase();
        String strCertPath = installData.getVariable("syracuse.dir.certs") + File.separator + localHOST_NAME;
        File dirCerts = new File(strCertPath);
        if (!dirCerts.exists()) {
            dirCerts.mkdirs();
        }
        if (!(dirCertToolPath = new File(strCertToolPath = installData.getVariable("syracuse.certificate.certtool"))).exists()) {
            dirCertToolPath.mkdirs();
        }
        if (!(dirCertToolOutputPath = new File(strCertToolPath + File.separator + "output")).exists()) {
            dirCertToolOutputPath.mkdirs();
        }
        if (!(dirCertToolPrivatePath = new File(strCertToolPath + File.separator + "private")).exists()) {
            dirCertToolPrivatePath.mkdirs();
        }
        this.pairCA = CertificateGeneratorHelper.generateRSAKeyPair(4096);
        this.cacert = CertificateGeneratorHelper.generateCAV3Certificate(this.pairCA, countryCode, organization, organizationalUnit, state, city, name, email, validity);
        File certsCaCRT = new File(strCertPath + File.separator + "ca.cacrt");
        FileWriter caCertFile = new FileWriter(certsCaCRT);
        JcaPEMWriter pem = new JcaPEMWriter((Writer)caCertFile);
        pem.writeObject((Object)this.cacert);
        pem.close();
        File certToolOutputCaCRT = new File(strCertToolPath + File.separator + "output" + File.separator + "ca.cacrt");
        Files.copy(certsCaCRT.toPath(), certToolOutputCaCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String caPassphrase = installData.getVariable("syracuse.certificate.capassphrase");
        CertificateGeneratorHelper.writePrivateKey(strCertToolPath + File.separator + "private" + File.separator + "ca.cakey", this.pairCA, caPassphrase.toCharArray());
        KeyPair pairServer = CertificateGeneratorHelper.generateRSAKeyPair(2048);
        String hostname = installData.getVariable("syracuse.certificate.hostname").toLowerCase();
        X509Certificate serverCert = CertificateGeneratorHelper.generateServerV3Certificate(pairServer, countryCode, organization, organizationalUnit, state, city, hostname, hostname, null, validity, this.cacert, this.pairCA);
        File certsServerCRT = new File(strCertPath + File.separator + localHOST_NAME + ".crt");
        FileWriter serverCertFile = new FileWriter(certsServerCRT);
        pem = new JcaPEMWriter((Writer)serverCertFile);
        pem.writeObject((Object)serverCert);
        pem.close();
        File certToolOutputServerCRT = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".crt");
        Files.copy(certsServerCRT.toPath(), certToolOutputServerCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String serverPassphrase = installData.getVariable("syracuse.certificate.serverpassphrase");
        CertificateGeneratorHelper.writePrivateKey(strCertPath + File.separator + localHOST_NAME + ".key", pairServer, serverPassphrase.toCharArray());
        File certToolOutputServerkey = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".key");
        File certsServerkey = new File(strCertPath + File.separator + localHOST_NAME + ".key");
        Files.copy(certsServerkey.toPath(), certToolOutputServerkey.toPath(), StandardCopyOption.REPLACE_EXISTING);
        File certToolOutputServerPub = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".pem");
        FileWriter serverPubFile = new FileWriter(certToolOutputServerPub);
        pem = new JcaPEMWriter((Writer)serverPubFile);
        pem.writeObject((Object)pairServer.getPublic());
        pem.close();
        boolean setx3runtime = Boolean.parseBoolean(installData.getVariable("syracuse.certificate.setx3runtime"));
        if (setx3runtime) {
            String strX3RuntimePath = installData.getVariable("syracuse.certificate.x3runtime");
            String pemName = localHOST_NAME.replace('@', '_').replace('$', '_').replace('.', '_');
            File x3ServerPub = new File(strX3RuntimePath + File.separator + "keys" + File.separator + pemName + ".pem");
            Files.copy(certToolOutputServerPub.toPath(), x3ServerPub.toPath(), StandardCopyOption.REPLACE_EXISTING);
            logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - setx3runtime=" + setx3runtime + "  '" + certToolOutputServerPub.toPath() + "' copied to '" + x3ServerPub.toPath() + "'");
        }
        if (setx3webserver = Boolean.parseBoolean(installData.getVariable("syracuse.certificate.setx3webserver"))) {
            String strX3WebserverPath = installData.getVariable("syracuse.certificate.x3webserverdata");
            String pemName = localHOST_NAME.replace('@', '_').replace('$', '_').replace('.', '_');
            File x3ServerPub = new File(strX3WebserverPath + File.separator + pemName + ".pem");
            Files.copy(certToolOutputServerPub.toPath(), x3ServerPub.toPath(), StandardCopyOption.REPLACE_EXISTING);
            logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - setx3webserver=" + setx3webserver + "  '" + certToolOutputServerPub.toPath() + "' copied to '" + x3ServerPub.toPath() + "'");
        }
        logger.log(Level.FINE, "CheckSyracuseCertManagerDataValidator - End certCreate()");
    }
}

