/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.coi.tools.os.win.RegDataContainer;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.core.resource.ResourceManager;
import com.sage.izpack.ModifyInstallationUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckProductAlreadyInstalled
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckProductAlreadyInstalled.class.getName());
    private static final String prefixLabel = "CheckProductAlreadyInstalled - ";
    private static final String SPEC_FILE_NAME = "productsSpec.txt";
    protected String errMessage = "";
    protected String warnMessage = "";
    private final RegistryHandler registryHandler;

    public CheckProductAlreadyInstalled(RegistryDefaultHandler handler) {
        this.registryHandler = handler.getInstance();
    }

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        InputStream input = null;
        try {
            String line;
            input = new ResourceManager().getInputStream(SPEC_FILE_NAME);
            logger.log(Level.FINE, "CheckProductAlreadyInstalled - input: " + input);
            if (input == null) {
                this.errMessage = "specFileMissing";
                logger.log(Level.FINE, "CheckProductAlreadyInstalled - input: " + this.errMessage);
                return DataValidator.Status.ERROR;
            }
            if (this.registryHandler == null) {
                logger.log(Level.FINE, "CheckProductAlreadyInstalled - this.registryHandler=NULL - Linux platform");
                return DataValidator.Status.OK;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                logger.log(Level.FINE, "line:" + line);
                line = line.trim();
                this.registryHandler.setRoot(-2147483646);
                if (this.registryHandler.keyExist("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + line)) {
                    logger.log(Level.FINE, "CheckProductAlreadyInstalled - MODIFY_INSTALLATION=true - Registry key exists:SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + line);
                    RegDataContainer oldInstallPath = this.registryHandler.getValue("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + line, "DisplayIcon");
                    String path = oldInstallPath.getStringData().substring(0, oldInstallPath.getStringData().indexOf("Uninstaller") - 1);
                    installData.setInstallPath(path);
                    ModifyInstallationUtil.set(installData, Boolean.TRUE);
                    logger.log(Level.FINE, "CheckProductAlreadyInstalled - Detected path: " + path);
                    return DataValidator.Status.OK;
                }
                logger.log(Level.FINE, "CheckProductAlreadyInstalled - MODIFY_INSTALLATION=false - Registry key not found:SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + line);
            }
            reader.close();
        }
        catch (Exception ex) {
            this.errMessage = ex.getMessage();
            logger.log(Level.SEVERE, this.errMessage);
            logger.log(Level.SEVERE, ex.getStackTrace().toString());
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return this.errMessage;
    }

    @Override
    public String getWarningMessageId() {
        return this.warnMessage;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

