/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.CDevLibrariesInfosfinder;
import com.sage.izpack.CDevToolsInfosFinder;
import com.sage.izpack.CLoggerUtils;
import com.sage.izpack.CReport;
import com.sage.izpack.CReportWritter;
import com.sage.izpack.CTextLineUtils;
import com.sage.izpack.CWordList;
import com.sage.izpack.GUIComponentSearcher;
import com.sage.izpack.OsVersionHelper;
import com.sage.izpack.StringUtil;
import com.sage.izpack.UserInputPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTextPane;

public class CheckJavaWebPrerequisitesValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckJavaWebPrerequisitesValidator.class.getName());
    private static final String prefixLabel = "CheckJavaWebPrerequisitesValidator - ";
    private static final int REPORT_WIDTH_200 = 200;
    private static final int REPORT_WIDTH_100 = 120;
    private static final int RESULT_FONT_SIZE_9 = 9;
    private final Resources resources;
    private GUIInstallData guiInstallData;
    private final InstallData _installData;

    public CheckJavaWebPrerequisitesValidator(InstallData installData, Resources resources) {
        this.resources = resources;
        this._installData = installData;
        if (installData instanceof GUIInstallData) {
            this.guiInstallData = (GUIInstallData)installData;
        }
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - CheckJavaWebPrerequisitesValidator. installData=" + installData);
    }

    private String dumpComponents(Container aContainer) {
        return this.dumpComponents(aContainer, new StringBuilder()).toString();
    }

    private StringBuilder dumpComponents(Container aContainer, StringBuilder aSB) {
        for (Component wComponent : aContainer.getComponents()) {
            boolean wIsTextPane = wComponent instanceof JTextPane;
            String wText = "";
            if (wIsTextPane) {
                wText = ((JTextPane)wComponent).getText();
            } else if (wComponent instanceof JLabel) {
                wText = ((JLabel)wComponent).getText();
            }
            aSB.append(CTextLineUtils.toInsecable(String.format("\n- isTextPane=[%-5s] Component=[%-12s][%s]", wIsTextPane, wComponent.getClass().getSimpleName(), wText)));
            if (!(wComponent instanceof Container)) continue;
            this.dumpComponents((Container)wComponent, aSB);
        }
        return aSB;
    }

    private String dumpVariables(InstallData installData) {
        StringBuilder wDump = new StringBuilder();
        Variables wVariables = installData.getVariables();
        int wIdx = 0;
        for (Map.Entry<Object, Object> wEntry : wVariables.getProperties().entrySet()) {
            wDump.append(CTextLineUtils.toInsecable(String.format("\n- %3d[%-60s]=[%s]", ++wIdx, String.valueOf(wEntry.getKey()), String.valueOf(wEntry.getValue()))));
        }
        return wDump.toString();
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "compileprerequisitestesterror";
    }

    private String getOsDetails(InstallData installData) {
        return String.format("%s - %s - %s", installData.getVariable("SYSTEM_os_name"), installData.getVariable("SYSTEM_os_version"), installData.getVariable("SYSTEM_os_arch")).replace('\n', ' ');
    }

    @Override
    public String getWarningMessageId() {
        return "compileprerequisitestesterror";
    }

    private boolean isConsoleMode(InstallData installData) {
        boolean result = this.isMode(installData, "console");
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isConsoleMode() result: " + result);
        return result;
    }

    private boolean isBatchMode(InstallData installData) {
        boolean result = this.isMode(installData, "auto");
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isBatchMode() result: " + result);
        return result;
    }

    private boolean isConsoleOrBatchMode(InstallData installData) {
        return this.isConsoleMode(installData) || this.isBatchMode(installData);
    }

    private boolean isMode(InstallData installData, String occurrence) {
        String wInstaller = installData.getVariable("INSTALLER_MODE");
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isMode(installData: " + installData + " occurrence:" + occurrence + ")   INSTALLER_MODE:" + wInstaller);
        boolean result = false;
        if (wInstaller != null && wInstaller.contains(occurrence)) {
            result = true;
        }
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isMode(occurrence:" + occurrence + ")  return " + result);
        return result;
    }

    private boolean isGuiMode(InstallData installData) {
        boolean result = !this.isConsoleOrBatchMode(installData);
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isGuiMode() result: " + result);
        return result;
    }

    private IzPanel retrieveCurrentPanel(GUIInstallData guiInstallData, InstallData installData) throws Exception {
        Panel panelFound = null;
        String panelValidator = null;
        for (Panel panel : installData.getPanelsOrder()) {
            List<String> validators = panel.getValidators();
            for (String validator : validators) {
                if (!validator.equals(this.getClass().getName())) continue;
                panelFound = panel;
                panelValidator = validator;
            }
        }
        if (panelFound != null) {
            logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - PanelFound:" + panelFound + " panelValidator:" + panelValidator);
        } else {
            logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - Current panel NOT FOUND. ");
        }
        if (guiInstallData == null && installData instanceof GUIInstallData) {
            guiInstallData = (GUIInstallData)installData;
        }
        if (guiInstallData != null) {
            for (IzPanel wPanel : guiInstallData.getPanels()) {
                UserInputPanel userinput;
                if (!(wPanel instanceof UserInputPanel) || StringUtil.isNullOrBlank((userinput = (UserInputPanel)wPanel).getId()) || !userinput.getId().equals(panelFound.getPanelId())) continue;
                logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - userinput: " + userinput + " userinput.getId(): " + userinput.getId() + " panelFound:" + panelFound);
                return userinput;
            }
        }
        throw new Exception("CheckJavaWebPrerequisitesValidator - Unable to retrieve the current panel");
    }

    private JTextPane searchJTextPaneProgress(Container aContainer) throws Exception {
        return new GUIComponentSearcher<JTextPane>(JTextPane.class, aContainer, 3).search();
    }

    private JTextPane searchJTextPaneResult(Container aContainer) throws Exception {
        return new GUIComponentSearcher<JTextPane>(JTextPane.class, aContainer, 4).search();
    }

    private void setProgress(InstallData installData, String aInfos) throws Exception {
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - setProgress");
        if (this.isGuiMode(installData)) {
            JTextPane wTextPaneResultLabel = this.searchJTextPaneProgress(this.retrieveCurrentPanel(this.guiInstallData, installData));
            String wText = wTextPaneResultLabel.getText();
            if (wText != null) {
                int wPos = wText.indexOf(58);
                if (wPos > -1) {
                    wText = wText.substring(0, wPos);
                }
            } else {
                wText = "Result";
            }
            wTextPaneResultLabel.setText(String.format("%s: %s", wText, aInfos));
        } else {
            CLoggerUtils.logInfo("Progress: %s", aInfos);
        }
    }

    private void setResult(InstallData installData, boolean aIsOK, CReport aReport) throws Exception {
        IzPanel wPanel = this.retrieveCurrentPanel(this.guiInstallData, installData);
        CLoggerUtils.logInfo("Components of the panel:%s", this.dumpComponents(wPanel));
        JTextPane wJTextPaneResult = this.searchJTextPaneResult(wPanel);
        wJTextPaneResult.setForeground(aIsOK ? Color.BLACK : Color.BLUE);
        wJTextPaneResult.setFont(new Font("Monospaced", 0, 9));
        wJTextPaneResult.setText(aReport.toStringWithoutNow());
    }

    private void LogInfo(InstallData installData, String message) {
        if (this.isGuiMode(installData)) {
            CLoggerUtils.logInfo(message);
        } else {
            System.out.println(message);
        }
    }

    private void LogError(InstallData installData, String mesg) {
        if (this.isGuiMode(installData)) {
            CLoggerUtils.logSevere(mesg);
        } else {
            System.err.println(mesg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataValidator.Status validateData(InstallData installData) {
        boolean wIsRedHatOrOracleLinux;
        this.LogInfo(installData, "Validator begin. aData: " + installData);
        boolean wIsOK = false;
        DataValidator.Status wValidatorStatus = DataValidator.Status.ERROR;
        CReportWritter wReportWritter = null;
        CReport wReport = new CReport(this.getClass().getSimpleName(), this.isConsoleOrBatchMode(installData) ? 120 : 200);
        if (Debug.isTRACE()) {
            wReport.setConsoleLogOn(true);
        } else {
            wReport.setConsoleLogOn(false);
        }
        boolean bl = wIsRedHatOrOracleLinux = OsVersion.IS_REDHAT_LINUX || OsVersionHelper.IS_ORACLE_LINUX;
        if (!wIsRedHatOrOracleLinux) {
            wReport.appendStep("WARNING NOT 'REDHAT_LINUX' OR 'ORACLE_LINUX' : [%s]", this.getOsDetails(installData));
        }
        if (Debug.isTRACE()) {
            wReport.appendStep("Current variables", new Object[0]);
            wReport.append("Variables: %s", this.dumpVariables(installData));
        }
        try {
            wIsOK = this.validPrerequisites(wReport, installData, this.resources);
            wValidatorStatus = wIsOK ? DataValidator.Status.OK : DataValidator.Status.ERROR;
            wReport.append("");
            wReport.append("Validator status = [%s]", wValidatorStatus.name());
            if (!wIsOK) {
                wReportWritter = new CReportWritter(wReport, "_onError");
                wReport.append("OutputFile = [%s]", wReportWritter.getOutputFile());
            }
        }
        catch (Exception e) {
            wReport.appendError(e);
        }
        if (wReportWritter != null) {
            try {
                wReportWritter.write();
                this.LogInfo(installData, String.format("NbWritedBytes = [%s]", Files.size(wReportWritter.getOutputFile().toPath())));
            }
            catch (Exception e) {
                CLoggerUtils.logSevere(e);
            }
        }
        if (this.isGuiMode(installData)) {
            try {
                this.setResult(installData, wIsOK, wReport);
            }
            catch (Exception e) {
                CLoggerUtils.logSevere(e);
            }
        } else if (!wIsOK) {
            this.LogInfo(installData, wReport.toStringWithoutNow());
            this.LogError(installData, "INSTALLATION STOPPED");
        }
        this.LogInfo(installData, "Validator end.");
        return wValidatorStatus;
    }

    private boolean validPrerequisites(CReport aReport, InstallData installData, Resources resources) throws Exception {
        aReport.appendStep("validPrerequisites searching tools", new Object[0]);
        String wToolsDef = installData.getVariable("compile.prerequisites.control.packages.tools");
        CWordList wToolList = new CWordList(aReport, "tool", wToolsDef.split(","));
        wToolList.SetFriendlySuccessMsg(installData.getVariable("compile.prerequisites.control.packages.successmessage"));
        wToolList.SetFriendlyWarningMsg(installData.getVariable("compile.prerequisites.control.packages.warningmessage"));
        this.setProgress(installData, String.format("Searching %d tools : %s", wToolList.size(), wToolsDef));
        aReport.append(wToolList.dumpAsNumberedList());
        String wDevToolsInfos = new CDevToolsInfosFinder(aReport, installData, resources).execute();
        boolean wToolsFound = wToolList.isAllWordsIn(wDevToolsInfos, CWordList.EKindOfFinding.AT_THE_BEGINING_OF_A_LINE);
        this.setProgress(installData, String.format("All tools found=[%b]", wToolsFound));
        aReport.appendStep("validPrerequisites searching libraries", new Object[0]);
        String wLibsDef = installData.getVariable("compile.prerequisites.control.packages.libs");
        CWordList wLibraryList = new CWordList(aReport, "library", wLibsDef.split(","));
        wLibraryList.SetFriendlySuccessMsg(installData.getVariable("compile.prerequisites.control.packages.successmessage"));
        wLibraryList.SetFriendlyWarningMsg(installData.getVariable("compile.prerequisites.control.packages.warningmessage"));
        this.setProgress(installData, String.format("Searching %d libraries : %s", wLibraryList.size(), wLibsDef));
        aReport.append(wLibraryList.dumpAsNumberedList());
        String wDevLibrariesInfos = new CDevLibrariesInfosfinder(aReport, installData, resources).execute();
        boolean wLibraryFound = wLibraryList.isAllWordsIn(wDevLibrariesInfos, CWordList.EKindOfFinding.AT_THE_BEGINING_OF_A_LINE);
        this.setProgress(installData, String.format("All libraries found=[%b]", wLibraryFound));
        this.setProgress(installData, "");
        return wToolsFound && wLibraryFound;
    }
}

