/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.licence;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.util.PanelHelper;
import java.net.URL;

class LicenceLoader {
    private final Panel panel;
    private final Resources resources;
    private final String panelResourceName;

    LicenceLoader(Panel panel, Resources resources) {
        this.panel = panel;
        this.resources = resources;
        this.panelResourceName = PanelHelper.getPanelResourceName(panel, "licence", resources);
    }

    URL asURL() throws ResourceException {
        try {
            return this.resources.getURL(this.panelResourceName);
        }
        catch (ResourceNotFoundException ignored) {
            String panelClassName = this.panel.getClassName();
            String panelName = panelClassName.substring(panelClassName.lastIndexOf(46) + 1);
            String message = "Could not open license document for the resource id " + this.panelResourceName + " of the panel " + panelName;
            throw new ResourceNotFoundException(message);
        }
    }

    String asString() {
        return this.resources.getString(this.panelResourceName, "Could not open license document for the resource id " + this.panelResourceName);
    }
}

