/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.file;

import com.izforge.izpack.api.exception.MergeException;
import com.izforge.izpack.merge.AbstractMerge;
import com.izforge.izpack.merge.resolve.ResolveUtils;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;

public class FileMerge
extends AbstractMerge {
    private final File sourceToCopy;
    private final String destination;

    public FileMerge(URL url, Map<OutputStream, List<String>> mergeContent) {
        this(url, "", mergeContent);
    }

    public FileMerge(URL url, String destination, Map<OutputStream, List<String>> mergeContent) {
        this.mergeContent = mergeContent;
        this.sourceToCopy = FileUtil.convertUrlToFile(url);
        this.destination = destination;
    }

    @Override
    public File find(FileFilter fileFilter) {
        return this.findRecursivelyForFile(fileFilter, this.sourceToCopy);
    }

    @Override
    public List<File> recursivelyListFiles(FileFilter fileFilter) {
        ArrayList<File> result = new ArrayList<File>();
        this.findRecursivelyForFiles(fileFilter, this.sourceToCopy, result);
        return result;
    }

    private File findRecursivelyForFile(FileFilter fileFilter, File currentFile) {
        if (currentFile != null && currentFile.isDirectory()) {
            File[] files = currentFile.listFiles(fileFilter);
            if (files != null) {
                for (File file : files) {
                    File f = this.findRecursivelyForFile(fileFilter, file);
                    if (f == null) continue;
                    return f;
                }
            }
        } else {
            return currentFile;
        }
        return null;
    }

    private void findRecursivelyForFiles(FileFilter fileFilter, File currentFile, List<File> result) {
        if (currentFile != null) {
            if (currentFile.isDirectory()) {
                File[] files = currentFile.listFiles(fileFilter);
                if (files != null) {
                    for (File file : files) {
                        result.add(currentFile);
                        this.findRecursivelyForFiles(fileFilter, file, result);
                    }
                }
            } else {
                result.add(currentFile);
            }
        }
    }

    @Override
    public void merge(ZipOutputStream outputStream) {
        try {
            this.copyFileToJar(this.sourceToCopy, outputStream);
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
    }

    private void copyFileToJar(File fileToCopy, ZipOutputStream outputStream) throws IOException {
        if (fileToCopy.isDirectory()) {
            File[] files = fileToCopy.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.copyFileToJar(file, outputStream);
                }
            }
        } else {
            String entryName = this.resolveName(fileToCopy, this.destination);
            List<String> mergeList = this.getMergeList(outputStream);
            if (mergeList.contains(entryName)) {
                return;
            }
            mergeList.add(entryName);
            FileInputStream inputStream = new FileInputStream(fileToCopy);
            IoHelper.copyStreamToJar(inputStream, outputStream, entryName, fileToCopy.lastModified());
            inputStream.close();
        }
    }

    private String resolveName(File fileToCopy, String destination) {
        if (this.isFile(destination)) {
            return destination;
        }
        String path = ResolveUtils.convertPathToPosixPath(this.sourceToCopy.getAbsolutePath());
        if (destination.equals("")) {
            path = ResolveUtils.convertPathToPosixPath(this.sourceToCopy.getParentFile().getAbsolutePath());
        }
        path = path + '/';
        StringBuilder builder = new StringBuilder();
        builder.append(destination);
        String absolutePath = ResolveUtils.convertPathToPosixPath(fileToCopy.getAbsolutePath());
        builder.append(absolutePath.replaceAll(path, ""));
        return builder.toString().replaceAll("//", "/");
    }

    private boolean isFile(String destination) {
        return destination.length() != 0 && (!destination.contains("/") || !destination.endsWith("/"));
    }

    public String toString() {
        return "FileMerge{sourceToCopy=" + this.sourceToCopy + ", destination='" + this.destination + '\'' + '}';
    }
}

