/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.regex;

import com.izforge.izpack.api.regex.RegularExpressionProcessor;
import com.izforge.izpack.util.regex.RegexUtil;
import com.izforge.izpack.util.regex.Regexp;
import com.izforge.izpack.util.regex.RegularExpression;
import java.util.Vector;

public class RegularExpressionProcessorImpl
implements RegularExpressionProcessor {
    private String input;
    private RegularExpression regexp;
    private String select;
    private String replace;
    private String defaultValue;
    private boolean caseSensitive = true;
    private boolean global = true;

    @Override
    public void setInput(String input) {
        this.input = input;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setRegexp(String regex) throws RuntimeException {
        this.regexp = new RegularExpression();
        this.regexp.setPattern(regex);
    }

    @Override
    public void setReplace(String replace) {
        if (this.select != null) {
            throw new IllegalArgumentException("You cannot specify both a select and replace expression");
        }
        this.replace = replace;
    }

    @Override
    public void setSelect(String select) {
        if (this.replace != null) {
            throw new IllegalArgumentException("You cannot specify both a select and replace expression");
        }
        this.select = select;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public void setGlobal(boolean global) {
        this.global = global;
    }

    protected String doReplace() throws RuntimeException {
        if (this.replace == null) {
            throw new IllegalArgumentException("No replace expression specified.");
        }
        int options = 0;
        if (!this.caseSensitive) {
            options |= 0x100;
        }
        if (this.global) {
            options |= 0x10;
        }
        Regexp sregex = this.regexp.getRegexp();
        String output = null;
        if (sregex.matches(this.input, options)) {
            output = sregex.substitute(this.input, this.replace, options);
        }
        if (output == null) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            if (this.replace != null) {
                return this.input;
            }
        }
        return output;
    }

    protected String doSelect() throws RuntimeException {
        if (this.select == null) {
            throw new IllegalArgumentException("No select expression specified.");
        }
        int options = 0;
        if (!this.caseSensitive) {
            options |= 0x100;
        }
        Regexp sregex = this.regexp.getRegexp();
        String output = this.select;
        Vector<String> groups = sregex.getGroups(this.input, options);
        output = groups != null && groups.size() > 0 ? RegexUtil.select(this.select, groups) : null;
        if (output == null) {
            output = this.defaultValue;
        }
        return output;
    }

    protected void validate() {
        if (this.regexp == null) {
            throw new IllegalArgumentException("No match expression specified.");
        }
        if (this.replace == null && this.select == null) {
            throw new IllegalArgumentException("You must specify either a replace or select expression");
        }
    }

    @Override
    public String execute() {
        this.validate();
        if (this.replace != null) {
            return this.doReplace();
        }
        return this.doSelect();
    }
}

