/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.finish.FinishPanel;
import com.sage.izpack.FinishNewPanelAutomationHelper;
import com.sage.izpack.InstallationInformationHelper;
import com.sage.izpack.ResourcesHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class FinishNewPanel
extends FinishPanel {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(FinishNewPanel.class.getName());
    private static String logPrefix = "FinishNewPanel instance. ";
    private final UninstallDataWriter uninstallDataWriter;
    private final Resources resources;
    private final ResourcesHelper resourceHelper;

    public FinishNewPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, UninstallDataWriter uninstallDataWriter, UninstallData uninstallData, Log log) {
        super(panel, parent, installData, resources, uninstallDataWriter, uninstallData, log);
        logger.log(Level.FINE, logPrefix + "Init custom resources.");
        this.uninstallDataWriter = uninstallDataWriter;
        this.resources = resources;
        this.resourceHelper = new ResourcesHelper(installData, resources);
        this.resourceHelper.mergeCustomMessages();
        logger.log(Level.FINE, logPrefix + "Custom resources initialized");
    }

    @Override
    public void panelActivate() {
        boolean uninstallRequired = this.uninstallDataWriter.isUninstallRequired();
        logger.log(Level.FINE, logPrefix + "uninstallRequired:" + uninstallRequired);
        FinishNewPanelAutomationHelper.initUninstallPath(this.resources, this.installData);
        logger.log(Level.FINE, logPrefix + "getUninstallerPath:" + this.installData.getInfo().getUninstallerPath());
        this.writeUninstallData();
        if (InstallationInformationHelper.isWriteInformation(this.installData)) {
            try {
                InstallationInformationHelper.writeInformation(this.installData);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, logPrefix + "Error while writing installationinformation: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        } else {
            logger.log(Level.FINE, logPrefix + "Skip writing installation information");
        }
        super.panelActivate();
    }

    private boolean writeUninstallData() {
        boolean result = true;
        boolean wasIzPack4 = InstallationInformationHelper.isLegacyIzpackInfo();
        this.installData.setVariable("force-generate-uninstaller", String.valueOf(wasIzPack4));
        boolean uninstallRequired = this.uninstallDataWriter.isUninstallRequired();
        logger.log(Level.FINE, logPrefix + "writeUninstallData. uninstallRequired:" + uninstallRequired);
        if (!uninstallRequired && wasIzPack4) {
            result = this.uninstallDataWriter.write();
            logger.log(Level.FINE, logPrefix + "force writeUninstallData. uninstallDataWriter.write() returns " + result);
            if (!result) {
                String title = this.resourceHelper.getCustomString("installer.error");
                String message = this.resourceHelper.getCustomString("installer.uninstall.writefailed");
                JOptionPane.showMessageDialog(this, message, title, 0);
            }
        }
        return result;
    }
}

