/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.checkedhello.CheckedHelloPanel;
import com.izforge.izpack.panels.checkedhello.RegistryHelper;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.CheckedHelloNewPanelAutomationHelper;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.RegistryHandlerX3;
import com.sage.izpack.ResourcesHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class CheckedHelloNewPanel
extends CheckedHelloPanel {
    private static Logger logger = Logger.getLogger(CheckedHelloNewPanel.class.getName());
    private static final String logPrefix = "CheckedHelloNewPanel - ";
    private static final long serialVersionUID = 1737042770727953387L;
    private ResourcesHelper _resourceHelper = null;
    private final RegistryDefaultHandler _handler;
    private final RegistryHelper _registryHelper;
    private RegistryHandler _registryHandler;
    private final Resources _resources;
    private RegistryHandlerX3 _x3Handler;

    public CheckedHelloNewPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, RegistryDefaultHandler handler, Log log) throws Exception {
        super(panel, parent, installData, resources, handler, log);
        this._resourceHelper = new ResourcesHelper(installData, resources);
        this._resourceHelper.mergeCustomMessages();
        this._registryHelper = new RegistryHelper(handler, installData);
        this._registryHandler = handler != null ? handler.getInstance() : null;
        this._handler = handler;
        this._resources = resources;
        this._x3Handler = new RegistryHandlerX3(this._registryHandler, installData);
        CheckedHelloNewPanel.initPath(this.installData, resources, this._registryHelper, this._x3Handler);
    }

    public static String initPath(InstallData installData, Resources resources, RegistryHelper registryHelper, RegistryHandlerX3 x3Handler) throws NativeLibException {
        String path = installData.getInstallPath();
        String logPrefix = "CheckedHelloNewPanel initPath - ";
        logger.log(Level.FINE, logPrefix + "getInstallPath: " + path);
        if (path != null) {
            logger.log(Level.FINE, logPrefix + "path: " + path + " init from installData.getInstallPath()");
        }
        if (path == null && OsVersion.IS_WINDOWS && (path = registryHelper.getInstallationPath()) != null) {
            logger.log(Level.FINE, logPrefix + "path: " + path + " init from registryHelper.getInstallationPath()");
        }
        if (path == null) {
            if (x3Handler.isAdminSetup() && (path = x3Handler.getAdxAdminDirPath()) != null) {
                logger.log(Level.FINE, logPrefix + "path: " + path + " init from x3Handler.getAdxAdminDirPath()");
            }
            logger.log(Level.FINE, logPrefix + "Warning: Could not get RegistryHandler.getInstallationPath() return NULL. path: " + path);
        }
        if (path != null) {
            String targetPanelDir = "TargetPanel.dir.windows";
            if (OsVersion.IS_LINUX) {
                targetPanelDir = "TargetPanel.dir.unix";
                installData.setVariable(targetPanelDir, path);
            } else {
                installData.setVariable(targetPanelDir, path);
            }
            logger.log(Level.FINE, logPrefix + "Set " + targetPanelDir + ": " + path);
            installData.setVariable("INSTALL_PATH", path);
            logger.log(Level.FINE, logPrefix + "Set INSTALL_PATH: " + path);
        }
        logger.log(Level.FINE, logPrefix + "InitPath returned path:" + path);
        return path;
    }

    @Override
    public void panelActivate() {
        if (this._x3Handler.needAdxAdmin()) {
            try {
                boolean adxAdminInstalled;
                String adxAdminPath = this._x3Handler.getAdxAdminDirPath();
                boolean bl = adxAdminInstalled = adxAdminPath != null;
                if (!adxAdminInstalled) {
                    logger.log(Level.FINE, logPrefix + this.getString("adxadminNotRegistered"));
                    JOptionPane.showMessageDialog(null, this.getString("adxadminNotRegistered"), this.getString("installer.error"), 0);
                    this.parent.lockNextButton();
                    return;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, logPrefix + this.getString("installer.error") + ":" + e.getMessage());
                JOptionPane.showMessageDialog(null, e.getMessage(), this.getString("installer.error"), 0);
                this.parent.lockNextButton();
                return;
            }
        }
        if (this.abortInstallation) {
            String allowMultipleInstall = this.installData.getVariable("allow-multiple-instance");
            if (Boolean.TRUE.toString().equalsIgnoreCase(allowMultipleInstall)) {
                logger.log(Level.FINE, "CheckedHelloNewPanel - allow-multiple-instance=true");
                this.parent.lockNextButton();
                try {
                    CheckedHelloNewPanelAutomationHelper.setUniqueUninstallKey(this._registryHandler, this._registryHelper, this._resourceHelper);
                    this.abortInstallation = false;
                    this.parent.unlockNextButton();
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, exception.getMessage(), exception);
                }
            } else {
                logger.log(Level.FINE, "CheckedHelloNewPanel - allowMultipleInstance=false (updatemode)");
                this.parent.lockNextButton();
                try {
                    if (this.multipleInstall()) {
                        this.abortInstallation = false;
                        this.parent.unlockNextButton();
                    }
                    this.installData.getInfo().setUninstallerPath(null);
                    this.installData.getInfo().setUninstallerName(null);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        Variables variables = this.installData.getVariables();
        this.installData.setVariable("UNINSTALL_NAME", variables.get("APP_NAME"));
    }

    @Override
    protected boolean isRegistered() throws Exception {
        boolean result = false;
        try {
            if (OsVersion.IS_WINDOWS) {
                result = super.isRegistered();
            }
            if (!result) {
                logger.log(Level.FINE, "CheckedHelloNewPanel - isRegistered()  Could not get RegistryHandler.getInstallationPath() return NULL" + this._registryHelper + " IsUnix: " + OsVersion.IS_UNIX);
                if (OsVersion.IS_UNIX) {
                    if (this._x3Handler == null) {
                        this._x3Handler = new RegistryHandlerX3(this._registryHandler, this.installData);
                    }
                    logger.log(Level.FINE, "CheckedHelloNewPanel - isRegistered()  is-adxdmin: " + this._x3Handler.isAdminSetup());
                    if (this._x3Handler.isAdminSetup() && this._x3Handler.getAdxAdminDirPath() != null) {
                        result = true;
                    }
                    String appName = this.installData.getVariable("APP_NAME");
                    logger.log(Level.FINE, "CheckedHelloNewPanel - isRegistered:" + result + " Set Uninstallname: " + appName);
                    if (OsVersion.IS_WINDOWS) {
                        if (this._registryHandler == null) {
                            RegistryHandler registryHandler = this._registryHandler = this._handler != null ? this._handler.getInstance() : null;
                        }
                        if (this._registryHandler != null) {
                            this._registryHandler.setUninstallName(appName);
                        } else {
                            logger.log(Level.WARNING, "CheckedHelloNewPanel - isRegistered() CANNOT set Uninstallname: " + appName);
                        }
                    }
                    this.installData.setVariable("UNINSTALL_NAME", appName);
                }
            }
            if (result) {
                ModifyInstallationUtil.set((InstallData)this.installData, Boolean.TRUE);
            }
            logger.log(Level.FINE, "CheckedHelloNewPanel - isRegistered()  Set modify.izpack.install: " + result);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "CheckedHelloNewPanel - isRegistered error : " + ex);
            ex.printStackTrace();
            throw ex;
        }
        return result;
    }

    @Override
    public String getString(String key) {
        ResourcesHelper helper = new ResourcesHelper(this.installData, this.getResources());
        String result = helper.getCustomString(key);
        if (result == null || !result.equals(key)) {
            result = super.getString(key);
        }
        return result;
    }

    @Override
    protected boolean multipleInstall() throws NativeLibException {
        String path = this.installData.getInstallPath();
        if (path == null && OsVersion.IS_WINDOWS) {
            path = this._registryHelper.getInstallationPath();
        }
        if (path == null) {
            if (this._x3Handler == null) {
                this._x3Handler = new RegistryHandlerX3(this._registryHandler, this.installData);
            }
            if (this._x3Handler.isAdminSetup()) {
                path = this._x3Handler.getAdxAdminDirPath();
            }
        }
        if (path == null) {
            path = "<not found>";
        }
        String noLuck = this.getString("CheckedHelloNewPanel.productAlreadyExist0") + path + ". " + this.getString("CheckedHelloNewPanel.productAlreadyExist1");
        return this.askQuestion(this.getString("installer.warning"), noLuck, 37) == 47;
    }
}

