/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.event.AbstractUninstallerListener;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.exception.WrappedNativeLibException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.handler.PromptUIHandler;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.helper.SpecHelper;
import com.sage.izpack.AdxCompHelper;
import com.sage.izpack.ResourcesHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AdxCompUninstallerListenerCommon
extends AbstractUninstallerListener {
    public static final String PrivilegesFriendlyMessage = "It looks that you don't have enough rights. You need to launch the 'Uninstaller' program from 'Add or remove programs' to get all privileges. ";
    public static final String SPEC_FILE_NAME = "AdxCompSpec.xml";
    private static final String LogPrefix = "AdxCompUninstallerListenerCommon - ";
    private static final Logger logger = Logger.getLogger(AdxCompUninstallerListenerCommon.class.getName());
    protected final Resources resources;
    protected final Prompt prompt;
    protected final Messages messages;
    protected SpecHelper specHelper = null;
    protected static boolean processDone = false;

    public AdxCompUninstallerListenerCommon(Resources resources, Messages messages, Prompt prompt) {
        this.prompt = prompt;
        this.resources = resources;
        this.messages = messages;
        this.specHelper = new SpecHelper(this.resources);
    }

    protected void emitWarning(String title, String message) {
        PromptUIHandler UIHandler = new PromptUIHandler(this.prompt);
        if (this.prompt != null && UIHandler != null) {
            UIHandler.emitWarning(title, message);
        } else {
            System.err.println(message);
        }
    }

    protected void emitError(String message, Exception exceptionMesg) {
        PromptUIHandler UIHandler = new PromptUIHandler(this.prompt);
        if (this.prompt != null && UIHandler != null) {
            UIHandler.emitError("Error", message);
        } else {
            System.err.println(message);
        }
        if (exceptionMesg != null) {
            System.err.println(exceptionMesg.getMessage());
        }
    }

    @Override
    public void initialise() {
        logger.log(Level.FINE, "AdxCompUninstallerListenerCommon - initialise");
    }

    @Override
    public void beforeDelete(List<File> arg0) {
        logger.log(Level.FINE, "AdxCompUninstallerListenerCommon - .beforeDelete(List<File>arg0: " + arg0 + ")");
        super.beforeDelete(arg0);
        this.beforeDeletion();
    }

    @Override
    public void beforeDelete(List<File> arg0, ProgressListener arg1) {
        logger.log(Level.FINE, "AdxCompUninstallerListenerCommon - .beforeDelete(List<File> arg0, ProgressListener arg1)");
        super.beforeDelete(arg0, arg1);
        this.beforeDeletion();
    }

    @Override
    public void beforeDelete(File arg0) {
        logger.log(Level.FINE, "AdxCompUninstallerListenerCommon - .beforeDelete(File arg0:" + arg0 + ")");
        super.beforeDelete(arg0);
        this.beforeDeletion();
    }

    @Override
    public boolean isFileListener() {
        return true;
    }

    @Override
    public void afterDelete(File arg0) {
    }

    @Override
    public void afterDelete(List<File> arg0, ProgressListener arg1) {
    }

    protected Document getAdxInstallDocument() throws FileNotFoundException, NativeLibException, IOException, Exception {
        AdxCompHelper adxCompHelper = new AdxCompHelper(null, null);
        Document adxInstallXmlDoc = adxCompHelper.getAdxInstallDocument();
        return adxInstallXmlDoc;
    }

    protected String getAdxAdminPath() throws FileNotFoundException, NativeLibException, IOException, Exception {
        AdxCompHelper adxCompHelper = new AdxCompHelper(null, null);
        return adxCompHelper.getAdxAdminPath();
    }

    protected File getAdxInstallFile(File adxAdminDir) {
        AdxCompHelper adxCompHelper = new AdxCompHelper(null, null);
        return adxCompHelper.getAdxInstallFile(adxAdminDir);
    }

    private boolean deleteAdxAdmFile() {
        boolean result = false;
        try {
            File adxadmFile;
            String path = "c:\\sage\\adxadm";
            if (OsVersion.IS_UNIX) {
                path = "/sage/adxadm";
            }
            if (!(adxadmFile = new File(path)).exists()) {
                return false;
            }
            adxadmFile.delete();
            result = true;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            this.emitError("Error", ex);
        }
        return result;
    }

    private void cleanAdxInstallXml(String logPrefix, Element elemSpecDoc) throws TransformerFactoryConfigurationError, FileNotFoundException, NativeLibException, IOException, Exception {
        String moduleName = elemSpecDoc.getAttribute("name");
        String moduleFamily = elemSpecDoc.getAttribute("family");
        Document adxInstallXmlDoc = this.getAdxInstallDocument();
        File adxAdminDir = new File(this.getAdxAdminPath());
        File adxInstallFile = this.getAdxInstallFile(adxAdminDir);
        if (adxInstallXmlDoc == null && !adxInstallFile.exists()) {
            System.out.println(logPrefix + "Xml file " + adxInstallFile.getAbsolutePath() + " doesn't exist.");
            return;
        }
        logger.log(Level.FINE, logPrefix + "moduleSpec 0: + " + AdxCompHelper.asString(elemSpecDoc, "utf-8") + "  moduleName found: " + moduleName + "   moduleFamily found: " + moduleFamily);
        Element adxXmlModule = this.getModule(adxInstallXmlDoc, elemSpecDoc, moduleName, moduleFamily);
        if (adxXmlModule == null) {
            System.out.println(logPrefix + "module " + moduleName + "/" + moduleFamily + " not in " + adxAdminDir.getAbsolutePath() + ". Check finished.");
            return;
        }
        logger.log(Level.FINE, logPrefix + "module " + moduleName + "/" + moduleFamily + " found in " + adxAdminDir.getAbsolutePath() + " Remove XML and document.");
        this.cleanAndSave(this.getAdxInstallFile(adxAdminDir), adxInstallXmlDoc, moduleName, moduleFamily, adxXmlModule);
    }

    protected void beforeDeletion() {
        String logPrefix = "AdxCompUninstallerListener.beforeDeletion - ";
        logger.log(Level.FINE, logPrefix + "");
        if (processDone) {
            logger.log(Level.FINE, logPrefix + " skipped. processDone");
            return;
        }
        try {
            Element elemSpecDoc = this.readAdxIzInstaller();
            if (elemSpecDoc == null) {
                logger.log(Level.FINE, logPrefix + SPEC_FILE_NAME + " not found. Nothing to do.");
            } else {
                this.cleanAdxInstallXml(logPrefix, elemSpecDoc);
            }
            boolean isAdxAdmin = this.isAdxAdmin();
            if (isAdxAdmin) {
                Document adxInstallXmlDoc = this.getAdxInstallDocument();
                if (adxInstallXmlDoc == null) {
                    logger.log(Level.FINE, this.getAdxAdminPath() + " doesn't exist or cannot be opened.");
                } else {
                    NodeList listAdxInstallsNodes = adxInstallXmlDoc.getDocumentElement().getElementsByTagName("module");
                    int nodes = 0;
                    if (listAdxInstallsNodes != null) {
                        nodes = listAdxInstallsNodes.getLength();
                    }
                    if (nodes > 0) {
                        String remaining = this.getString("uninstaller.adxadmin.remainingmodules", "remaining modules children: cancel installation !");
                        System.out.println(remaining);
                        this.emitError(remaining, null);
                        System.exit(1);
                    }
                }
                this.deleteAdxAdmFile();
            }
            processDone = true;
        }
        catch (WrappedNativeLibException exception) {
            this.emitError(this.getString("privilegesIssue", PrivilegesFriendlyMessage), exception);
            throw exception;
        }
        catch (Exception exception) {
            this.emitError(this.getString("privilegesIssue", PrivilegesFriendlyMessage), exception);
            throw new IzPackException(exception);
        }
    }

    protected boolean isAdxAdmin() throws Exception {
        boolean isAdxAdminB = this.isAdxAdminFromPath();
        if (!isAdxAdminB) {
            isAdxAdminB = this.isAdxAdminFromVariables();
        }
        return isAdxAdminB;
    }

    private boolean isAdxAdminFromVariables() {
        boolean isAdxAdminB = false;
        try {
            Object varObject = this.resources.getObject("variables");
            if (varObject != null && varObject instanceof Variables) {
                Variables variables = (Variables)varObject;
                String isAdxAdmin = variables != null ? variables.get("is-adxadmin") : null;
                isAdxAdminB = isAdxAdmin != null && isAdxAdmin.equalsIgnoreCase("true");
                logger.log(Level.FINE, "AdxCompUninstallerListenerCommon - isAdxAdminFromVariables returns " + isAdxAdminB);
            }
        }
        catch (Exception e) {
            return false;
        }
        return isAdxAdminB;
    }

    protected boolean isAdxAdminFromPath() {
        String installPath = this.getInstallPath();
        String adxAdminPath = null;
        try {
            adxAdminPath = this.getAdxAdminPath();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return installPath != null && adxAdminPath != null && installPath.equalsIgnoreCase(adxAdminPath);
    }

    public String getInstallPath() {
        String result = null;
        try {
            InputStream in = this.getClass().getResourceAsStream("/install.log");
            InputStreamReader inReader = new InputStreamReader(in);
            BufferedReader reader = new BufferedReader(inReader);
            result = reader.readLine();
            if (result != null) {
                result = result.trim();
            }
            reader.close();
        }
        catch (Exception exception) {
            System.err.println("AdxCompUninstallerListenerCommon - unable to determine install path: " + exception.getMessage());
        }
        return result;
    }

    protected Element readAdxIzInstaller() {
        Element elemSpecDoc = null;
        try {
            InputStream in = this.resources.getInputStream(SPEC_FILE_NAME);
            ObjectInputStream objIn = new ObjectInputStream(in);
            String obj = (String)objIn.readObject();
            elemSpecDoc = AdxCompHelper.asXml(obj);
            objIn.close();
            in.close();
        }
        catch (Exception exception) {
            System.err.println("AdxCompUninstallerListenerCommon - Cannot read AdxCompSpec.xml - " + exception.getMessage());
        }
        return elemSpecDoc;
    }

    protected String getString(String resourceId, String defaultTranslation) {
        String result;
        ResourcesHelper helper = new ResourcesHelper(null, this.resources);
        if (this.messages != null) {
            helper.mergeCustomMessages(this.messages);
        }
        if ((result = helper.getCustomString(resourceId)) == null) {
            result = defaultTranslation;
        }
        return result;
    }

    protected void cleanAndSave(File fileAdxinstalls, Document adxInstallXmlDoc, String moduleName, String moduleFamily, Element moduleToRemove) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException, ParserConfigurationException {
        NodeList lstChilds = moduleToRemove.getElementsByTagName("*");
        for (int i = 0; i < lstChilds.getLength(); ++i) {
            String modstatus;
            Element elem = (Element)lstChilds.item(i);
            if (!elem.getTagName().endsWith(".installstatus") || "idle".equalsIgnoreCase(modstatus = elem.getTextContent())) continue;
            String errorMsg = "Error";
            String notidleMsg = "notidle";
            String friendlyMsg = this.getString(notidleMsg, errorMsg + ": module not idle (Status: " + modstatus + ") " + notidleMsg);
            this.emitWarning(errorMsg, friendlyMsg);
            System.exit(1);
        }
        moduleToRemove.getParentNode().removeChild(moduleToRemove);
        AdxCompHelper.saveXml(fileAdxinstalls, adxInstallXmlDoc, AdxCompHelper.getTransformer("UTF-8"));
    }

    protected Element getModule(Document adxInstallXmlDoc, Element moduleSpec, String moduleName, String moduleFamily) {
        Element result = null;
        NodeList listAdxInstallsNodes = adxInstallXmlDoc.getDocumentElement().getElementsByTagName("module");
        for (int i = 0; i < listAdxInstallsNodes.getLength(); ++i) {
            Element aNode = (Element)listAdxInstallsNodes.item(i);
            if (!aNode.getAttribute("name").equals(moduleName) || !aNode.getAttribute("type").equals(moduleSpec.getAttribute("type")) || !aNode.getAttribute("family").equals(moduleFamily)) continue;
            result = aNode;
            break;
        }
        return result;
    }
}

