/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.file.types.Parameter;
import com.izforge.izpack.util.file.types.selectors.BaseExtendSelector;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateSelector
extends BaseExtendSelector {
    private long millis = -1L;
    private String dateTime = null;
    private boolean includeDirs = false;
    private int granularity = 0;
    private TimeComparisons cmp = TimeComparisons.EQUAL;
    private String pattern;
    public static final String MILLIS_KEY = "millis";
    public static final String DATETIME_KEY = "datetime";
    public static final String CHECKDIRS_KEY = "checkdirs";
    public static final String GRANULARITY_KEY = "granularity";
    public static final String WHEN_KEY = "when";
    public static final String PATTERN_KEY = "pattern";

    public DateSelector() {
        if (OsVersion.IS_WINDOWS) {
            this.granularity = 2000;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{dateselector date: ");
        buf.append(this.dateTime);
        buf.append(" compare: ");
        buf.append(this.cmp.getAttribute());
        buf.append(" granularity: ");
        buf.append(this.granularity);
        if (this.pattern != null) {
            buf.append(" pattern: ").append(this.pattern);
        }
        buf.append("}");
        return buf.toString();
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public long getMillis() throws Exception {
        if (this.dateTime != null) {
            this.validate();
        }
        return this.millis;
    }

    public void setDatetime(String dateTime) {
        this.dateTime = dateTime;
    }

    public void setCheckdirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
    }

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }

    public void setWhen(TimeComparisons cmp) {
        this.cmp = cmp;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String paramname = parameter.getName();
                if (MILLIS_KEY.equalsIgnoreCase(paramname)) {
                    try {
                        this.setMillis(new Long(parameter.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        this.setError("Invalid millisecond setting " + parameter.getValue());
                    }
                    continue;
                }
                if (DATETIME_KEY.equalsIgnoreCase(paramname)) {
                    this.setDatetime(parameter.getValue());
                    continue;
                }
                if (CHECKDIRS_KEY.equalsIgnoreCase(paramname)) {
                    this.setCheckdirs(Boolean.parseBoolean(parameter.getValue()));
                    continue;
                }
                if (GRANULARITY_KEY.equalsIgnoreCase(paramname)) {
                    try {
                        this.setGranularity(new Integer(parameter.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        this.setError("Invalid granularity setting " + parameter.getValue());
                    }
                    continue;
                }
                if (WHEN_KEY.equalsIgnoreCase(paramname)) {
                    TimeComparisons cmp = TimeComparisons.getFromAttribute(parameter.getValue());
                    if (cmp != null) {
                        this.setWhen(cmp);
                        continue;
                    }
                    this.setError("Invalid when setting " + parameter.getValue());
                    continue;
                }
                if (PATTERN_KEY.equalsIgnoreCase(paramname)) {
                    this.setPattern(parameter.getValue());
                    continue;
                }
                this.setError("Invalid parameter " + paramname);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.dateTime == null && this.millis < 0L) {
            this.setError("You must provide a datetime or the number of milliseconds.");
        } else if (this.millis < 0L && this.dateTime != null) {
            DateFormat df = this.pattern == null ? DateFormat.getDateTimeInstance(3, 3, Locale.US) : new SimpleDateFormat(this.pattern);
            try {
                this.setMillis(df.parse(this.dateTime).getTime());
                if (this.millis < 0L) {
                    this.setError("Date of " + this.dateTime + " results in negative milliseconds value relative to epoch (January 1, 1970, 00:00:00 GMT).");
                }
            }
            catch (ParseException pe) {
                this.setError("Date of " + this.dateTime + " Cannot be parsed correctly. It should be in" + (this.pattern == null ? " MM/DD/YYYY HH:MM AM_PM" : this.pattern) + " format.");
            }
        }
    }

    @Override
    public boolean isSelected(InstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        if (file.isDirectory() && !this.includeDirs) {
            return true;
        }
        switch (this.cmp) {
            case BEFORE: {
                return file.lastModified() - (long)this.granularity < this.millis;
            }
            case AFTER: {
                return file.lastModified() + (long)this.granularity > this.millis;
            }
        }
        return Math.abs(file.lastModified() - this.millis) <= (long)this.granularity;
    }

    public static enum TimeComparisons {
        BEFORE("before"),
        AFTER("after"),
        EQUAL("equal");

        private static Map<String, TimeComparisons> lookup;
        private String attribute;

        private TimeComparisons(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static TimeComparisons getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, TimeComparisons>();
            for (TimeComparisons mapperType : EnumSet.allOf(TimeComparisons.class)) {
                lookup.put(mapperType.getAttribute(), mapperType);
            }
        }
    }
}

