/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.installer.util.InstallPathHelper;
import com.izforge.izpack.panels.path.PathInputBase;
import com.izforge.izpack.panels.path.PathInputConsolePanel;
import com.izforge.izpack.panels.target.TargetPanelAutomation;
import com.izforge.izpack.panels.target.TargetPanelHelper;
import com.izforge.izpack.util.Console;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

public class TargetConsolePanel
extends PathInputConsolePanel
implements ConsolePanel {
    private final InstallData installData;

    public TargetConsolePanel(PanelView<ConsolePanel> panel, InstallData installData, Prompt prompt) {
        super(panel, "TargetPanel", installData, prompt);
        this.installData = installData;
    }

    @Override
    public boolean generateOptions(InstallData installData, Options options) {
        String name = "INSTALL_PATH";
        options.add("INSTALL_PATH", installData.getInstallPath());
        options.addEmptyLine("INSTALL_PATH");
        options.putComment("INSTALL_PATH", Arrays.asList(this.getPanel().getPanelId()));
        return true;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        boolean result = false;
        String path = properties.getProperty("INSTALL_PATH");
        if (path == null || "".equals(path.trim())) {
            System.err.println("Missing mandatory target path!");
        } else if (TargetPanelHelper.isIncompatibleInstallation(path, installData.getInfo().isReadInstallationInformation())) {
            System.err.println(this.getMessage("incompatibleInstallation"));
        } else {
            path = installData.getVariables().replace(path);
            installData.setInstallPath(path);
            result = true;
        }
        return result;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        String path;
        this.printHeadLine(installData, console);
        String introText = this.getI18nStringForClass("intro", "TargetPanel", installData);
        if (introText != null) {
            console.println(introText);
            console.println();
        }
        String defaultPath = InstallPathHelper.getPath(installData);
        PathInputBase.setInstallData(installData);
        if (defaultPath == null) {
            defaultPath = "";
        }
        while ((path = console.promptLocation(this.getMessage("info") + " [" + defaultPath + "] ", defaultPath)) != null) {
            path = installData.getVariables().replace(path);
            String normalizedPath = PathInputBase.normalizePath(path);
            File pathFile = new File(normalizedPath);
            if (TargetPanelHelper.isIncompatibleInstallation(normalizedPath, installData.getInfo().isReadInstallationInformation())) {
                console.println(this.getMessage("incompatibleInstallation"));
                continue;
            }
            if (!PathInputBase.isWritable(normalizedPath)) {
                console.println(this.getMessage("notwritable"));
                continue;
            }
            if (!normalizedPath.isEmpty()) {
                if (pathFile.isFile()) {
                    console.println(this.getMessage("isfile"));
                    continue;
                }
                if (pathFile.exists()) {
                    if (!this.checkOverwrite(pathFile, console)) {
                        continue;
                    }
                } else {
                    if (!this.checkCreateDirectory(pathFile, console)) continue;
                    if (!installData.getPlatform().isValidDirectoryPath(pathFile)) {
                        console.println(this.getMessage("syntax.error"));
                        continue;
                    }
                }
                installData.setInstallPath(normalizedPath);
                return this.promptEndPanel(installData, console);
            }
            return this.run(installData, console);
        }
        return false;
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        new TargetPanelAutomation().createInstallationRecord(this.installData, panelRoot);
    }
}

