/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.sage;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.UserInputPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.sage.CDevLibrariesInfosfinder;
import com.izforge.izpack.util.sage.CDevToolsInfosFinder;
import com.izforge.izpack.util.sage.CLoggerUtils;
import com.izforge.izpack.util.sage.CReport;
import com.izforge.izpack.util.sage.CReportWritter;
import com.izforge.izpack.util.sage.CTextLineUtils;
import com.izforge.izpack.util.sage.CWordList;
import com.izforge.izpack.util.sage.GUIComponentSearcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.nio.file.Files;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JTextPane;

public class CompilePrerequisitesControl
implements DataValidator {
    private static final int REPORT_WIDTH_200 = 200;
    private static final int REPORT_WIDTH_80 = 100;
    private static final int RESULT_FONT_SIZE_9 = 9;

    private String dumpComponents(Container aContainer) {
        return this.dumpComponents(aContainer, new StringBuilder()).toString();
    }

    private StringBuilder dumpComponents(Container aContainer, StringBuilder aSB) {
        for (Component wComponent : aContainer.getComponents()) {
            boolean wIsTextPane = wComponent instanceof JTextPane;
            String wText = "";
            if (wIsTextPane) {
                wText = ((JTextPane)wComponent).getText();
            } else if (wComponent instanceof JLabel) {
                wText = ((JLabel)wComponent).getText();
            }
            aSB.append(CTextLineUtils.toInsecable(String.format("\n- isTextPane=[%-5s] Component=[%-12s][%s]", wIsTextPane, wComponent.getClass().getSimpleName(), wText)));
            if (!(wComponent instanceof Container)) continue;
            this.dumpComponents((Container)wComponent, aSB);
        }
        return aSB;
    }

    private String dumpVariables(AutomatedInstallData aData) {
        StringBuilder wDump = new StringBuilder();
        Properties wVariables = aData.getVariables();
        TreeMap<Object, Object> wSortedProperties = new TreeMap<Object, Object>(wVariables);
        int wIdx = 0;
        for (Map.Entry wEntry : wSortedProperties.entrySet()) {
            wDump.append(CTextLineUtils.toInsecable(String.format("\n- %3d[%-60s]=[%s]", ++wIdx, String.valueOf(wEntry.getKey()), String.valueOf(wEntry.getValue()))));
        }
        return wDump.toString();
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "compileprerequisitestesterror";
    }

    private String getOsDetails(AutomatedInstallData aData) {
        return String.format("%s - %s - %s", aData.getVariable("SYSTEM_os_name"), aData.getVariable("SYSTEM_os_version"), aData.getVariable("SYSTEM_os_arch")).replace('\n', ' ');
    }

    @Override
    public String getWarningMessageId() {
        return "compileprerequisitestesterror";
    }

    private boolean isConsoleMode(AutomatedInstallData aData) {
        return this.isMode(aData, "console");
    }

    private boolean isBatchMode(AutomatedInstallData aData) {
        return this.isMode(aData, "automated");
    }

    private boolean isMode(AutomatedInstallData aData, String occurrence) {
        String wInstaller = aData.getVariable("INSTALLER");
        if (wInstaller != null && wInstaller.contains(occurrence)) {
            return true;
        }
        String wJavaCommand = aData.getVariable("SYSTEM_sun_java_command");
        return wJavaCommand != null && wJavaCommand.contains(occurrence);
    }

    private boolean isGuiMode(AutomatedInstallData aData) {
        return !this.isConsoleMode(aData) && !this.isBatchMode(aData);
    }

    private IzPanel retrieveCurrentPanel(AutomatedInstallData aData) throws Exception {
        for (IzPanel wPanel : aData.panels) {
            boolean wIsCurrentPanel;
            if (!(wPanel instanceof UserInputPanel) || !(wIsCurrentPanel = wPanel.getValidationService() == this)) continue;
            return wPanel;
        }
        throw new Exception("Unable to retrieve the current panel");
    }

    private JTextPane searchJTextPaneProgress(Container aContainer) throws Exception {
        return new GUIComponentSearcher<JTextPane>(JTextPane.class, aContainer, 3).search();
    }

    private JTextPane searchJTextPaneResult(Container aContainer) throws Exception {
        return new GUIComponentSearcher<JTextPane>(JTextPane.class, aContainer, 4).search();
    }

    private void setProgress(AutomatedInstallData aData, String aInfos) throws Exception {
        if (this.isGuiMode(aData)) {
            JTextPane wTextPaneResultLabel = this.searchJTextPaneProgress(this.retrieveCurrentPanel(aData));
            String wText = wTextPaneResultLabel.getText();
            if (wText != null) {
                int wPos = wText.indexOf(58);
                if (wPos > -1) {
                    wText = wText.substring(0, wPos);
                }
            } else {
                wText = "Result";
            }
            wTextPaneResultLabel.setText(String.format("%s: %s", wText, aInfos));
        } else {
            CLoggerUtils.logInfo("Progress: %s", aInfos);
        }
    }

    private void setResult(AutomatedInstallData aData, boolean aIsOK, CReport aReport) throws Exception {
        IzPanel wPanel = this.retrieveCurrentPanel(aData);
        CLoggerUtils.logInfo("Components of the panel:%s", this.dumpComponents(wPanel));
        JTextPane wJTextPaneResult = this.searchJTextPaneResult(wPanel);
        wJTextPaneResult.setForeground(aIsOK ? Color.BLACK : Color.BLUE);
        wJTextPaneResult.setFont(new Font("Monospaced", 0, 9));
        wJTextPaneResult.setText(aReport.toStringWithoutNow());
    }

    private void LogInfo(AutomatedInstallData aData, String mesg) {
        if (this.isGuiMode(aData)) {
            CLoggerUtils.logInfo(mesg);
        } else {
            System.out.println(mesg);
        }
    }

    private void LogError(AutomatedInstallData aData, String mesg) {
        if (this.isGuiMode(aData)) {
            CLoggerUtils.logSevere(mesg);
        } else {
            System.err.println(mesg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataValidator.Status validateData(AutomatedInstallData aData) {
        boolean wIsRedHatOrOracleLinux;
        this.LogInfo(aData, "Validator begin.");
        boolean wIsOK = false;
        DataValidator.Status wValidatorStatus = DataValidator.Status.ERROR;
        CReportWritter wReportWritter = null;
        CReport wReport = new CReport(this.getClass().getSimpleName(), this.isConsoleMode(aData) ? 100 : 200);
        if (Debug.isTRACE()) {
            wReport.setConsoleLogOn(true);
        } else {
            wReport.setConsoleLogOn(false);
        }
        boolean bl = wIsRedHatOrOracleLinux = OsVersion.IS_REDHAT_LINUX || OsVersion.IS_ORACLE_LINUX;
        if (!wIsRedHatOrOracleLinux) {
            wReport.appendStep("WARNING NOT 'REDHAT_LINUX' OR 'ORACLE_LINUX' : [%s]", this.getOsDetails(aData));
        }
        if (Debug.isTRACE()) {
            wReport.appendStep("Current variables", new Object[0]);
            wReport.append("Variables: %s", this.dumpVariables(aData));
        }
        try {
            wIsOK = this.validPrerequisites(wReport, aData);
            wValidatorStatus = wIsOK ? DataValidator.Status.OK : DataValidator.Status.ERROR;
            wReport.append("");
            wReport.append("Validator status = [%s]", wValidatorStatus.name());
            if (!wIsOK) {
                wReportWritter = new CReportWritter(wReport, "_onError");
                wReport.append("OutputFile = [%s]", wReportWritter.getOutputFile());
            }
        }
        catch (Exception e) {
            wReport.appendError(e);
        }
        if (wReportWritter != null) {
            try {
                wReportWritter.write();
                this.LogInfo(aData, String.format("NbWritedBytes = [%s]", Files.size(wReportWritter.getOutputFile().toPath())));
            }
            catch (Exception e) {
                CLoggerUtils.logSevere(e);
            }
        }
        if (this.isGuiMode(aData)) {
            try {
                this.setResult(aData, wIsOK, wReport);
            }
            catch (Exception e) {
                CLoggerUtils.logSevere(e);
            }
        } else if (!wIsOK) {
            this.LogInfo(aData, wReport.toStringWithoutNow());
            this.LogError(aData, "INSTALLATION STOPPED");
        }
        this.LogInfo(aData, "Validator end.");
        return wValidatorStatus;
    }

    private boolean validPrerequisites(CReport aReport, AutomatedInstallData aData) throws Exception {
        aReport.appendStep("validPrerequisites searching tools", new Object[0]);
        String wToolsDef = aData.getVariable("compile.prerequisites.control.packages.tools");
        CWordList wToolList = new CWordList(aReport, "tool", wToolsDef.split(","));
        wToolList.SetFriendlySuccessMsg(aData.getVariable("compile.prerequisites.control.packages.successmessage"));
        wToolList.SetFriendlyWarningMsg(aData.getVariable("compile.prerequisites.control.packages.warningmessage"));
        this.setProgress(aData, String.format("Searching %d tools : %s", wToolList.size(), wToolsDef));
        aReport.append(wToolList.dumpAsNumberedList());
        String wDevToolsInfos = new CDevToolsInfosFinder(aReport, aData).execute();
        boolean wToolsFound = wToolList.isAllWordsIn(wDevToolsInfos, CWordList.EKindOfFinding.AT_THE_BEGINING_OF_A_LINE);
        this.setProgress(aData, String.format("All tools found=[%b]", wToolsFound));
        aReport.appendStep("validPrerequisites searching libraries", new Object[0]);
        String wLibsDef = aData.getVariable("compile.prerequisites.control.packages.libs");
        CWordList wLibraryList = new CWordList(aReport, "library", wLibsDef.split(","));
        wLibraryList.SetFriendlySuccessMsg(aData.getVariable("compile.prerequisites.control.packages.successmessage"));
        wLibraryList.SetFriendlyWarningMsg(aData.getVariable("compile.prerequisites.control.packages.warningmessage"));
        this.setProgress(aData, String.format("Searching %d libraries : %s", wLibraryList.size(), wLibsDef));
        aReport.append(wLibraryList.dumpAsNumberedList());
        String wDevLibrariesInfos = new CDevLibrariesInfosfinder(aReport, aData).execute();
        boolean wLibraryFound = wLibraryList.isAllWordsIn(wDevLibrariesInfos, CWordList.EKindOfFinding.AT_THE_BEGINING_OF_A_LINE);
        this.setProgress(aData, String.format("All libraries found=[%b]", wLibraryFound));
        this.setProgress(aData, "");
        return wToolsFound && wLibraryFound;
    }
}

