/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.sage;

public class CTextLineUtils {
    public static final char CHAR_SPACE = ' ';
    public static final char CHAR_SPACE_INSECABLE = '\u00a0';

    public static String generateLineBeginEnd(char aChar, int aLen) {
        return aChar + String.valueOf(new char[aLen - 2]).replace('\u0000', '\u00a0') + aChar;
    }

    public static String generateLineBeginEnd(char aChar, int aLen, String aText) {
        String wLine = CTextLineUtils.generateLineBeginEnd(aChar, aLen);
        if (aText != null && !aText.isEmpty()) {
            String wText = CTextLineUtils.truncate(aText, aLen - 4);
            int wLen = aLen - (aLen - (2 + wText.length()));
            wLine = wLine.substring(0, 2) + wText + wLine.substring(wLen);
        }
        return CTextLineUtils.toInsecable(wLine);
    }

    public static String generateLineFull(char aChar, int aLen) {
        return String.valueOf(new char[aLen]).replace('\u0000', aChar);
    }

    public static String generateLineFull(char aChar, int aLen, String aText) {
        String wLine = CTextLineUtils.generateLineFull(aChar, aLen);
        if (aText != null && !aText.isEmpty()) {
            String wLabel = CTextLineUtils.truncate('\u00a0' + CTextLineUtils.toInsecable(aText) + '\u00a0', aLen - 8);
            int wLen = aLen - (aLen - (4 + wLabel.length()));
            wLine = wLine.substring(0, 4) + wLabel + wLine.substring(wLen);
        }
        return wLine;
    }

    public static String toInsecable(String aLine) {
        return aLine.replace(' ', '\u00a0');
    }

    public static String truncate(String aText, int aLen) {
        return aText != null && aText.length() > aLen ? aText.substring(0, aLen) : aText;
    }

    private CTextLineUtils() {
    }
}

