/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.Debug;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoIterable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDBDataValidator
implements DataValidator {
    private static boolean isSupportedVersion(String version) {
        Integer majorVersion = 0;
        try {
            String[] verStr1 = version.split("\\.");
            if (verStr1[0] == null || verStr1[0].trim().length() == 0) {
                verStr1[0] = "0";
            }
            majorVersion = Integer.valueOf(verStr1[0]);
        }
        catch (NumberFormatException e) {
            majorVersion = 0;
        }
        return majorVersion >= 3;
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        DataValidator.Status bReturn = DataValidator.Status.OK;
        try {
            Boolean modifyinstallation = Boolean.valueOf(adata.getVariable("MODIFY.IZPACK.INSTALL"));
            String hostName = new String(adata.getVariable("mongodb.service.hostname"));
            String hostPort = adata.getVariable("mongodb.service.port");
            boolean sslEnabled = "true".equalsIgnoreCase(adata.getVariable("mongodb.ssl.enable"));
            String certFile = adata.getVariable("mongodb.ssl.client.certfile");
            String pemkeyFile = adata.getVariable("mongodb.ssl.client.pemkeyfile");
            String pemcaFile = adata.getVariable("mongodb.ssl.pemcafile");
            if (!sslEnabled) {
                MongoClient mongoClient = new MongoClient(hostName, Integer.parseInt(hostPort));
                String version = mongoClient.getDatabase("test").runCommand((Bson)new Document("buildInfo", (Object)1)).getString((Object)"version");
                if (!MongoDBDataValidator.isSupportedVersion(version)) {
                    bReturn = DataValidator.Status.ERROR;
                } else {
                    MongoIterable lstDb = mongoClient.listDatabaseNames();
                    for (String dbb : lstDb) {
                        if (!dbb.equals("syracuse")) continue;
                        if (modifyinstallation.booleanValue()) {
                            bReturn = DataValidator.Status.OK;
                            break;
                        }
                        bReturn = DataValidator.Status.WARNING;
                        break;
                    }
                }
                mongoClient.close();
            } else {
                Security.addProvider((Provider)new BouncyCastleProvider());
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                ArrayList<X509Certificate> chainArray = new ArrayList<X509Certificate>();
                if (pemcaFile != null && !"".equals(pemcaFile)) {
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustStore.load(null, null);
                    FileInputStream inPemCaFile = new FileInputStream(pemcaFile);
                    X509Certificate cacert = (X509Certificate)factory.generateCertificate(inPemCaFile);
                    trustStore.setCertificateEntry("root", cacert);
                    File trustStoreFile = File.createTempFile("tru", null);
                    FileOutputStream trustStoreFileOutputStream = new FileOutputStream(trustStoreFile);
                    trustStore.store(trustStoreFileOutputStream, "truststore".toCharArray());
                    trustStoreFileOutputStream.close();
                    chainArray.add(cacert);
                    System.setProperty("javax.net.ssl.trustStore", trustStoreFile.getAbsolutePath());
                    System.setProperty("javax.net.ssl.trustStorePassword", "truststore");
                }
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                FileInputStream inPemCertFile = new FileInputStream(certFile);
                X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
                FileInputStream inPemKeyFile = new FileInputStream(pemkeyFile);
                PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(inPemKeyFile));
                Object object = pemParser.readObject();
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                PEMKeyPair ukp = (PEMKeyPair)object;
                KeyPair kp = converter.getKeyPair(ukp);
                keyStore.setCertificateEntry(cert.getSubjectX500Principal().toString(), cert);
                chainArray.add(cert);
                Certificate[] chain = new X509Certificate[chainArray.size()];
                chain[0] = cert;
                if (chainArray.size() > 1) {
                    chain[1] = (X509Certificate)chainArray.get(0);
                }
                keyStore.setKeyEntry("importkey", kp.getPrivate(), "keystore".toCharArray(), chain);
                File keyStoreFile = File.createTempFile("key", null);
                FileOutputStream keyStoreFileOutputStream = new FileOutputStream(keyStoreFile);
                keyStore.store(keyStoreFileOutputStream, "keystore".toCharArray());
                keyStoreFileOutputStream.close();
                System.setProperty("javax.net.ssl.keyStore", keyStoreFile.getAbsolutePath());
                System.setProperty("javax.net.ssl.keyStorePassword", "keystore");
                System.setProperty("jdk.tls.trustNameService", "true");
                MongoClientOptions.Builder opts = MongoClientOptions.builder();
                opts.sslEnabled(true);
                opts.serverSelectionTimeout(60000);
                MongoClient mongoClient = new MongoClient(new ServerAddress(hostName, Integer.parseInt(hostPort)), opts.build());
                String version = mongoClient.getDatabase("test").runCommand((Bson)new Document("buildInfo", (Object)1)).getString((Object)"version");
                if (!MongoDBDataValidator.isSupportedVersion(version)) {
                    bReturn = DataValidator.Status.ERROR;
                } else {
                    MongoIterable lstDb = mongoClient.listDatabaseNames();
                    for (String dbb : lstDb) {
                        if (!dbb.equals("syracuse")) continue;
                        if (modifyinstallation.booleanValue()) {
                            bReturn = DataValidator.Status.OK;
                            break;
                        }
                        bReturn = DataValidator.Status.WARNING;
                        break;
                    }
                }
                mongoClient.close();
            }
        }
        catch (Exception ex) {
            Debug.trace(ex.getMessage());
            bReturn = DataValidator.Status.ERROR;
        }
        return bReturn;
    }

    @Override
    public String getErrorMessageId() {
        return "mongodbtesterror";
    }

    @Override
    public String getWarningMessageId() {
        return "mongodbtestwarn";
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

