/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;

public class KeyPairGeneratorDataValidator
implements DataValidator {
    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        DataValidator.Status bReturn = DataValidator.Status.ERROR;
        try {
            String passPhrase = "";
            if (adata.getVariable("tool.passphrase") != null) {
                passPhrase = adata.getVariable("tool.passphrase");
            }
            File publicKeyFile = File.createTempFile("public", ".pem");
            File privateKeyFile = File.createTempFile("private", ".pem");
            String publicKeyFileName = publicKeyFile.getAbsolutePath();
            String privateKeyFileName = privateKeyFile.getAbsolutePath();
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "SunJSSE");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            keyGen.initialize(2048, random);
            KeyPair pair = keyGen.generateKeyPair();
            KeyPairGeneratorDataValidator.writePublic(publicKeyFileName, pair.getPublic());
            KeyPairGeneratorDataValidator.writePrivateKey(privateKeyFileName, pair, passPhrase.toCharArray());
            bReturn = DataValidator.Status.OK;
            adata.setVariable("tool.temp.publickeyfile", publicKeyFileName);
            adata.setVariable("tool.temp.privatekeyfile", privateKeyFileName);
        }
        catch (Exception ex) {
            Debug.trace(ex.getMessage());
            bReturn = DataValidator.Status.ERROR;
        }
        return bReturn;
    }

    @Override
    public String getErrorMessageId() {
        return "keypairgenerationerror";
    }

    @Override
    public String getWarningMessageId() {
        return "keypairgenerationwarn";
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    private static void writePublic(String filename, PublicKey publicKey) throws IOException {
        try (PEMWriter pemWriter = new PEMWriter((Writer)new PrintWriter(new FileWriter(filename)));){
            pemWriter.writeObject((Object)publicKey);
            pemWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writePrivateKey(String filename, KeyPair key, char[] passphrase) throws IOException {
        FileWriter writer = new FileWriter(filename);
        JcePEMEncryptorBuilder jeb = new JcePEMEncryptorBuilder("DES-EDE3-CBC");
        jeb.setProvider("SunJCE");
        try (PEMWriter pemWriter = new PEMWriter((Writer)new PrintWriter(writer));){
            if (passphrase != null && passphrase.length > 0) {
                PEMEncryptor pemEncryptor = jeb.build(passphrase);
                pemWriter.writeObject((Object)key, pemEncryptor);
            } else {
                pemWriter.writeObject((Object)key);
            }
            pemWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeFiles(File[] files, File mergedFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(mergedFile);
            for (File f : files) {
                int c;
                in = new FileInputStream(f);
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                in.close();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

