/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.OrCondition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;

public class XorCondition
extends OrCondition {
    private static final long serialVersionUID = 3148555083095194992L;

    public XorCondition() {
    }

    public XorCondition(Condition operand1, Condition operand2, AutomatedInstallData installdata) {
        super(operand1, operand2, installdata);
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) {
        try {
            if (xmlcondition.getChildrenCount() != 2) {
                Debug.log("xor-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(1));
        }
        catch (Exception e) {
            Debug.log("missing element in xor-condition");
        }
    }

    @Override
    public boolean isTrue() {
        if (this.leftoperand == null || this.rightoperand == null) {
            Debug.trace("Operands of condition " + this.id + " not initialized correctly.");
            return false;
        }
        this.leftoperand.setInstalldata(this.installdata);
        this.rightoperand.setInstalldata(this.installdata);
        boolean op1true = this.leftoperand.isTrue();
        boolean op2true = this.rightoperand.isTrue();
        if (op1true && op2true) {
            return false;
        }
        return op1true || op2true;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on:<ul><li>");
        details.append(this.leftoperand.getDependenciesDetails());
        details.append("</li> XOR <li>");
        details.append(this.rightoperand.getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }
}

