/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.sage;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ReadMePanel
extends IzPanel
implements HyperlinkListener,
ActionListener {
    private static final long serialVersionUID = 3256745385458746416L;
    private JCheckBox readCheckBox;
    private JEditorPane textArea;

    public ReadMePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.loadReadMe();
        this.add((Component)LabelFactory.create(parent.langpack.getString("ReadMePanel.info"), parent.icons.getImageIcon("history"), 10), "nextLine");
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadReadMe());
            this.add((Component)scroller, "nextLine");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        ButtonGroup group = new ButtonGroup();
        this.readCheckBox = new JCheckBox(parent.langpack.getString("ReadMePanel.agree"), false);
        group.add(this.readCheckBox);
        this.add((Component)this.readCheckBox, "nextLine");
        this.readCheckBox.addActionListener(this);
        this.setInitialFocus(this.textArea);
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.readCheckBox.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (Exception err) {
                    this.textArea.setPage(e.getURL());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isValidated() {
        if (!this.readCheckBox.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.readCheckBox.isSelected();
    }

    private URL loadReadMe() {
        String resNamePrifix = "ReadMePanel.readme";
        try {
            return ResourceManager.getInstance().getURL(resNamePrifix);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void panelActivate() {
        if (!this.readCheckBox.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

