/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.util.Debug;
import java.util.Map;
import java.util.Vector;

public class UserInputPanelAutomationHelper
implements PanelAutomation {
    private static final String AUTO_KEY_USER_INPUT = "userInput";
    private static final String AUTO_KEY_ENTRY = "entry";
    private static final String AUTO_ATTRIBUTE_KEY = "key";
    private static final String AUTO_ATTRIBUTE_VALUE = "value";
    private Map<String, String> entries;

    public UserInputPanelAutomationHelper() {
        this.entries = null;
    }

    public UserInputPanelAutomationHelper(Map<String, String> entries) {
        this.entries = entries;
    }

    @Override
    public void makeXMLData(AutomatedInstallData idata, IXMLElement panelRoot) {
        XMLElementImpl userInput = new XMLElementImpl(AUTO_KEY_USER_INPUT, panelRoot);
        panelRoot.addChild(userInput);
        for (String key : this.entries.keySet()) {
            String value = this.entries.get(key);
            XMLElementImpl dataElement = new XMLElementImpl(AUTO_KEY_ENTRY, userInput);
            dataElement.setAttribute(AUTO_ATTRIBUTE_KEY, key);
            dataElement.setAttribute(AUTO_ATTRIBUTE_VALUE, value);
            userInput.addChild(dataElement);
        }
    }

    @Override
    public void runAutomated(AutomatedInstallData idata, IXMLElement panelRoot) throws InstallerException {
        IXMLElement userInput = panelRoot.getFirstChildNamed(AUTO_KEY_USER_INPUT);
        if (userInput == null) {
            throw new InstallerException("Missing userInput element on line " + panelRoot.getLineNr());
        }
        Vector<IXMLElement> userEntries = userInput.getChildrenNamed(AUTO_KEY_ENTRY);
        if (userEntries == null) {
            throw new InstallerException("Missing entry element(s) on line " + panelRoot.getLineNr());
        }
        for (int i = 0; i < userEntries.size(); ++i) {
            IXMLElement dataElement = userEntries.elementAt(i);
            String variable = dataElement.getAttribute(AUTO_ATTRIBUTE_KEY);
            String value = dataElement.getAttribute(AUTO_ATTRIBUTE_VALUE);
            Debug.trace("UserInputPanel: setting variable " + variable + " to " + value);
            idata.setVariable(variable, value);
        }
    }
}

