/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.ValidatorContainer;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class TextInputField
extends JComponent {
    private static final long serialVersionUID = 8611515659787697087L;
    private JTextComponent field;
    private AutomatedInstallData idata = null;
    IzPanel parent;
    List<ValidatorContainer> validators;
    InstallerFrame parentFrame;

    public TextInputField(IzPanel parent, String set, int size, int rows, List<ValidatorContainer> validatorConfig, AutomatedInstallData idata) {
        this.parent = parent;
        this.parentFrame = parent.getInstallerFrame();
        this.validators = validatorConfig;
        this.idata = idata;
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(3);
        layout.setVgap(0);
        this.setLayout(layout);
        if (rows > 1) {
            JTextArea area = new JTextArea(set, rows, size);
            area.setCaretPosition(0);
            area.setWrapStyleWord(true);
            area.setLineWrap(true);
            this.field = area;
            this.add(new JScrollPane(area));
        } else {
            this.field = new JTextField(set, size);
            this.field.setCaretPosition(0);
            this.add(this.field);
        }
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String value) {
        this.field.setText(value);
    }

    public String getFieldContents(int index) {
        return this.field.getText();
    }

    public int getNumFields() {
        return 1;
    }

    public boolean validateContents() {
        String input = this.field.getText();
        StringInputProcessingClient processingClient = new StringInputProcessingClient(this.idata, input, this.validators);
        boolean success = processingClient.validate();
        if (!success) {
            JOptionPane.showMessageDialog(this.parentFrame, processingClient.getValidationMessage(), this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
        }
        return success;
    }
}

