/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.panels.TargetPanel;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;

public class TargetPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    protected String emptyTargetMsg = "";
    protected String warnMsg = "";
    protected String strTargetPath = "";

    public boolean initI18n(AutomatedInstallData installData) {
        this.emptyTargetMsg = installData.langpack.getString("TargetPanel.empty_target");
        this.warnMsg = installData.langpack.getString("TargetPanel.warn");
        String introText = installData.langpack.getString("PathInputPanel.extendedIntro");
        if ((introText == null || introText.endsWith("extendedIntro") || introText.indexOf(36) > -1) && ((introText = installData.langpack.getString("PathInputPanel.intro")) == null || introText.endsWith("intro"))) {
            introText = "";
        }
        return true;
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        this.initI18n(installData);
        printWriter.println("INSTALL_PATH=");
        return true;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        this.initI18n(installData);
        this.strTargetPath = p.getProperty("INSTALL_PATH");
        if (this.strTargetPath == null || "".equals(this.strTargetPath.trim())) {
            System.err.println("Inputting the target path is mandatory!!!!");
            return false;
        }
        VariableSubstitutor vs = new VariableSubstitutor(installData.getVariables());
        this.strTargetPath = vs.substitute(this.strTargetPath, null);
        installData.setInstallPath(this.strTargetPath);
        return true;
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata) {
        return this.runConsole(idata, true);
    }

    public boolean runConsole(AutomatedInstallData idata, boolean validateEnd) {
        this.initI18n(idata);
        String strDefaultPath = idata.getInstallPath();
        String path = TargetPanel.loadDefaultDirFromVariables(idata.getVariables());
        if (path != null) {
            strDefaultPath = path;
        }
        System.out.println(idata.langpack.getString("TargetPanel.info") + " [" + strDefaultPath + "] ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            String strIn = br.readLine();
            this.strTargetPath = !strIn.trim().equals("") ? strIn : strDefaultPath;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        if (!this.isValidated(vs.substitute(this.strTargetPath, null), idata)) {
            return false;
        }
        if (validateEnd) {
            int i = this.askEndOfConsolePanel(idata);
            if (i == 1) {
                idata.setInstallPath(this.strTargetPath);
                String summaryCaption = idata.langpack.getString("TargetPanel.summaryCaption");
                ArrayList<String> lstTarget = new ArrayList<String>();
                lstTarget.add(this.strTargetPath);
                idata.summaryText.put(summaryCaption, lstTarget);
                return true;
            }
            if (i == 2) {
                return false;
            }
            return this.runConsole(idata);
        }
        return true;
    }

    public boolean isValidated(String pstrPath, AutomatedInstallData idata) {
        String chosenPath = pstrPath;
        boolean ok = true;
        int nRet = 0;
        boolean mustExist = false;
        if (chosenPath.length() == 0) {
            nRet = this.emitWarning(idata, idata.langpack.getString("installer.warning"), this.emptyTargetMsg);
            if (nRet == 3) {
                return false;
            }
            if (nRet == 2) {
                return this.runConsole(idata, false);
            }
            nRet = 0;
        }
        if (chosenPath.startsWith("~")) {
            String home = System.getProperty("user.home");
            chosenPath = home + chosenPath.substring(1);
        }
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        boolean modifyinstallation = Boolean.valueOf(idata.getVariable("MODIFY.IZPACK.INSTALL"));
        if (modifyinstallation) {
            mustExist = true;
            File installationinformation = new File(chosenPath + File.separator + ".installationinformation");
            if (!installationinformation.exists()) {
                this.emitError(idata, idata.langpack.getString("installer.error"), idata.langpack.getString("PathInputPanel.required.forModificationInstallation"));
                return false;
            }
        }
        if (!this.isWriteable(chosenPath)) {
            this.emitError(idata, idata.langpack.getString("installer.error"), idata.langpack.getString("TargetPanel.notwritable"));
            return this.runConsole(idata, false);
        }
        if (!mustExist) {
            if (path.exists()) {
                nRet = this.emitWarning(idata, idata.langpack.getString("installer.warning"), this.warnMsg);
                if (nRet == 3) {
                    return false;
                }
                if (nRet == 2) {
                    return this.runConsole(idata, false);
                }
                nRet = 0;
            } else {
                String vStr = idata.getVariable("ShowCreateDirectoryMessage");
                if (vStr == null || Boolean.getBoolean(vStr)) {
                    nRet = this.emitWarning(idata, idata.langpack.getString("installer.warning"), idata.langpack.getString("TargetPanel.createdir") + " " + chosenPath);
                    if (nRet == 3) {
                        return false;
                    }
                    if (nRet == 2) {
                        return this.runConsole(idata, false);
                    }
                    nRet = 0;
                }
            }
        }
        this.strTargetPath = chosenPath;
        return ok;
    }
}

