/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.PathInputPanel;
import com.izforge.izpack.panels.TargetPanelAutomationHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.util.Properties;

public class TargetPanel
extends PathInputPanel {
    private static final long serialVersionUID = 3256443616359429170L;
    private boolean noWhitespaces;
    private static boolean userSet = false;

    public static void reset() {
        userSet = false;
    }

    public static String loadDefaultDirFromVariables(Properties vars) {
        String os = System.getProperty("os.name").replace(' ', '_').toLowerCase();
        String path = vars.getProperty("TargetPanel.dir.".concat(os));
        if (path == null && (path = vars.getProperty("TargetPanel.dir." + (OsVersion.IS_WINDOWS ? "windows" : (OsVersion.IS_OSX ? "macosx" : "unix")))) == null) {
            path = vars.getProperty("TargetPanel.dir");
        }
        if (path != null) {
            path = new VariableSubstitutor(vars).substitute(path, null);
        }
        return path;
    }

    public TargetPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        this.loadDefaultDir();
        String defDir = this.getDefaultDir();
        if (defDir != null) {
            idata.setInstallPath(defDir);
        }
        this.noWhitespaces = Boolean.valueOf(idata.getVariable("TargetPanel.noWhitespaces"));
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        this.loadDefaultDir();
        String defDir = this.getDefaultDir();
        if (!userSet && defDir != null) {
            this.idata.setInstallPath(defDir);
        }
        this.pathSelectionPanel.setPath(this.idata.getInstallPath());
    }

    public void loadDefaultDir() {
        String path = TargetPanel.loadDefaultDirFromVariables(this.idata.getVariables());
        if (path != null) {
            TargetPanel.setDefaultInstallDir(path);
            return;
        }
        PathInputPanel.loadDefaultInstallDir(this.parent, this.idata);
    }

    @Override
    public boolean isValidated() {
        if (this.noWhitespaces && this.pathSelectionPanel.getPath() != null && this.pathSelectionPanel.getPath().length() > 0 && this.pathSelectionPanel.getPath().contains(" ")) {
            this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("PathInputPanel.noWhitespaces"));
            return false;
        }
        if (!super.isValidated()) {
            return false;
        }
        this.idata.setInstallPath(this.pathSelectionPanel.getPath());
        userSet = true;
        return true;
    }

    public String getDefaultDir() {
        return TargetPanel.getDefaultInstallDir();
    }

    public void setDefaultDir(String defaultDir) {
        TargetPanel.setDefaultInstallDir(defaultDir);
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
        new TargetPanelAutomationHelper().makeXMLData(this.idata, panelRoot);
    }

    @Override
    public String getSummaryBody() {
        return this.idata.getInstallPath();
    }
}

