/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ProcessPanelWorker;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ProcessPanel
extends IzPanel
implements AbstractUIProcessHandler {
    private static final long serialVersionUID = 3258417209583155251L;
    protected JLabel processLabel;
    protected JProgressBar overallProgressBar;
    private boolean validated = false;
    private ProcessPanelWorker worker;
    private int noOfJobs = 0;
    private int currentJob = 0;
    private JTextArea outputPane;
    private static boolean finishedWork = false;

    public ProcessPanel(InstallerFrame parent, InstallData idata) throws IOException {
        super(parent, idata);
        this.worker = new ProcessPanelWorker(idata, this);
        JLabel heading = new JLabel();
        Font font = heading.getFont();
        font = font.deriveFont(1, (float)font.getSize() * 2.0f);
        heading.setFont(font);
        heading.setHorizontalAlignment(0);
        heading.setText(parent.langpack.getString("ProcessPanel.heading"));
        heading.setVerticalAlignment(1);
        BorderLayout layout = new BorderLayout();
        layout.setHgap(2);
        layout.setVgap(2);
        this.setLayout(layout);
        this.add((Component)heading, "North");
        JPanel subpanel = new JPanel();
        subpanel.setAlignmentX(0.5f);
        subpanel.setLayout(new BoxLayout(subpanel, 1));
        this.processLabel = new JLabel();
        this.processLabel.setAlignmentX(0.5f);
        this.processLabel.setText(" ");
        subpanel.add(this.processLabel);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setAlignmentX(0.5f);
        this.overallProgressBar.setStringPainted(true);
        subpanel.add(this.overallProgressBar);
        this.outputPane = new JTextArea();
        this.outputPane.setEditable(false);
        JScrollPane outputScrollPane = new JScrollPane(this.outputPane);
        subpanel.add(outputScrollPane);
        this.add((Component)subpanel, "Center");
    }

    @Override
    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void startProcessing(int no_of_jobs) {
        this.noOfJobs = no_of_jobs;
        this.overallProgressBar.setMaximum(no_of_jobs);
        this.overallProgressBar.setIndeterminate(true);
        this.parent.lockPrevButton();
    }

    @Override
    public void finishProcessing(boolean unlockPrev, boolean unlockNext) {
        this.overallProgressBar.setIndeterminate(false);
        String no_of_jobs = Integer.toString(this.noOfJobs);
        this.overallProgressBar.setString(no_of_jobs + " / " + no_of_jobs);
        this.processLabel.setText(" ");
        this.processLabel.setEnabled(false);
        this.validated = true;
        this.idata.installSuccess = this.worker.getResult();
        if (this.idata.panels.indexOf(this) != this.idata.panels.size() - 1 && unlockNext) {
            this.parent.unlockNextButton();
        }
        if (unlockPrev) {
            this.parent.unlockPrevButton();
        }
        finishedWork = this.idata.installSuccess;
    }

    @Override
    public void logOutput(String message, boolean stderr) {
        this.outputPane.append(message + '\n');
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProcessPanel.this.outputPane.setCaretPosition(ProcessPanel.this.outputPane.getText().length());
            }
        });
    }

    @Override
    public void startProcess(String jobName) {
        this.processLabel.setText(jobName);
        ++this.currentJob;
        this.overallProgressBar.setValue(this.currentJob);
        this.overallProgressBar.setString(Integer.toString(this.currentJob) + " / " + Integer.toString(this.noOfJobs));
    }

    @Override
    public void finishProcess() {
    }

    @Override
    public void panelActivate() {
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
        this.currentJob = 0;
        if (!finishedWork) {
            this.worker.startThread();
        }
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
    }
}

