/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.coi.tools.os.win.MSWinConstants;
import com.izforge.izpack.Info;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.PanelAutomationHelper;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;

public class HelloPanelAutomationHelper
extends PanelAutomationHelper
implements PanelAutomation,
AbstractUIProgressHandler,
MSWinConstants {
    protected boolean abortInstallation;
    protected AutomatedInstallData idata;

    @Override
    public void startAction(String name, int no_of_steps) {
    }

    @Override
    public void stopAction() {
    }

    @Override
    public void nextStep(String step_name, int step_no, int no_of_substeps) {
    }

    @Override
    public void setSubStepNo(int no_of_substeps) {
    }

    @Override
    public void progress(int substep_no, String message) {
    }

    @Override
    public void makeXMLData(AutomatedInstallData installData, IXMLElement panelRoot) {
    }

    @Override
    public void runAutomated(AutomatedInstallData installData, IXMLElement panelRoot) throws InstallerException {
        this.idata = installData;
        String str = this.idata.langpack.getString("HelloPanel.welcome1") + this.idata.info.getAppName() + " " + this.idata.info.getAppVersion() + this.idata.langpack.getString("HelloPanel.welcome2");
        System.out.println("");
        System.out.println(str);
        ArrayList<Info.Author> authors = this.idata.info.getAuthors();
        int size = authors.size();
        if (size > 0) {
            str = this.idata.langpack.getString("HelloPanel.authors");
            for (int i = 0; i < size; ++i) {
                Info.Author a = authors.get(i);
                String email = a.getEmail() != null && a.getEmail().length() > 0 ? " <" + a.getEmail() + ">" : "";
                System.out.println(" - " + a.getName() + email);
            }
        }
        if (this.idata.info.getAppURL() != null) {
            str = this.idata.langpack.getString("HelloPanel.url") + this.idata.info.getAppURL();
            System.out.println(str);
        }
        System.out.println("");
        if (!this.adxadminPresent(this.idata)) {
            this.emitErrorAndBlockNext("", this.idata.langpack.getString("installer.quit.message"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean adxadminPresent(AutomatedInstallData idata) {
        if (idata.info.needAdxAdmin()) {
            try {
                File adxadmFile;
                RegistryHandler rh = RegistryDefaultHandler.getInstance();
                if (rh != null) {
                    rh.verify(idata);
                    if (rh.adxadminProductRegistered()) return true;
                    System.out.println(idata.langpack.getString("adxadminNotRegistered"));
                    return false;
                }
                if (!OsVersion.IS_UNIX || (adxadmFile = new File("/sage/adxadm")).exists() || (adxadmFile = new File("/adonix/adxadm")).exists()) return true;
                System.out.println(idata.langpack.getString("adxadminNotRegistered"));
                return false;
            }
            catch (Exception e) {
                Debug.log(e);
                System.out.println(idata.langpack.getString("installer.error"));
                return false;
            }
        }
        if (!idata.info.isAdxAdmin()) return true;
        if (OsVersion.IS_UNIX) {
            File adxadmFileUnix = new File("/sage/adxadm");
            if (adxadmFileUnix.exists()) {
                try {
                    String adxadmPath = HelloPanelAutomationHelper.readFile("/sage/adxadm", Charset.defaultCharset());
                    adxadmPath = adxadmPath.replace("\r\n", "").replace("\n", "").trim();
                    String installInformation = adxadmPath + "/" + ".installationinformation";
                    File installInformationFile = new File(installInformation);
                    if (!installInformationFile.exists()) {
                        System.out.println(idata.langpack.getString("adxadminNoAdxDirSage"));
                        return false;
                    }
                    System.out.println(idata.langpack.getString("compFoundDoUpdate"));
                    System.out.println();
                    idata.setInstallPath(adxadmPath);
                    Debug.trace("modification installation");
                    idata.setVariable("MODIFY.IZPACK.INSTALL", "true");
                    return true;
                }
                catch (IOException e) {
                    System.out.println(idata.langpack.getString("adxadminNoAdxDirSage"));
                    return false;
                }
            }
            adxadmFileUnix = new File("/adonix/adxadm");
            if (!adxadmFileUnix.exists()) return true;
            try {
                String adxadmPath = HelloPanelAutomationHelper.readFile("/adonix/adxadm", Charset.defaultCharset());
                adxadmPath = adxadmPath.replace("\r\n", "").replace("\n", "").trim();
                System.out.println(idata.langpack.getString("adxadminV6found"));
                System.out.println(adxadmPath);
                return false;
            }
            catch (IOException e) {
                System.out.println(idata.langpack.getString("adxadminV6found"));
                return false;
            }
        }
        try {
            String strAdxAdminPath = "";
            RegistryHandler rh = RegistryDefaultHandler.getInstance();
            if (rh == null) return true;
            rh.verify(idata);
            if (!rh.adxadminProductRegistered()) return true;
            String keyName = "SOFTWARE\\Adonix\\X3RUNTIME\\ADXADMIN";
            int oldVal = rh.getRoot();
            rh.setRoot(-2147483646);
            if (!rh.valueExist(keyName, "ADXDIR")) {
                keyName = "SOFTWARE\\Wow6432Node\\Adonix\\X3RUNTIME\\ADXADMIN";
                if (!rh.valueExist(keyName, "ADXDIR")) {
                    System.out.println(idata.langpack.getString("adxadminNoAdxDirReg"));
                    rh.setRoot(oldVal);
                    return false;
                }
                strAdxAdminPath = rh.getValue(keyName, "ADXDIR").getStringData();
            } else {
                strAdxAdminPath = rh.getValue(keyName, "ADXDIR").getStringData();
            }
            rh.setRoot(oldVal);
            File fInstallINf = new File(strAdxAdminPath + File.separator + ".installationinformation");
            if (!fInstallINf.exists()) {
                System.out.println(idata.langpack.getString("adxadminV6found"));
                System.out.println(strAdxAdminPath);
                return false;
            }
            System.out.println(idata.langpack.getString("compFoundDoUpdate"));
            System.out.println();
            idata.setInstallPath(strAdxAdminPath);
            Debug.trace("modification installation");
            idata.setVariable("MODIFY.IZPACK.INSTALL", "true");
            return true;
        }
        catch (Exception e) {
            Debug.log(e);
            System.out.println(idata.langpack.getString("installer.error"));
            return false;
        }
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return encoding.decode(ByteBuffer.wrap(encoded)).toString();
    }
}

